/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache;

import coursierapi.shaded.coursier.cache.CachePolicy;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalOnly$;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalUpdateChanging$;
import coursierapi.shaded.coursier.cache.CachePolicy$Update$;
import coursierapi.shaded.coursier.credentials.Credentials;
import coursierapi.shaded.coursier.credentials.FileCredentials;
import coursierapi.shaded.coursier.credentials.FileCredentials$;
import coursierapi.shaded.coursier.parse.CachePolicyParser$;
import coursierapi.shaded.coursier.parse.CredentialsParser$;
import coursierapi.shaded.coursier.paths.CachePath;
import coursierapi.shaded.coursier.paths.CoursierPaths;
import coursierapi.shaded.coursier.util.Sync$;
import coursierapi.shaded.scala.Console$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.collection.ArrayOps$;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.SeqFactory;
import coursierapi.shaded.scala.collection.SeqFactory$UnapplySeqWrapper$;
import coursierapi.shaded.scala.collection.SeqOps;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.collection.immutable.$colon$colon;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.mutable.ArraySeq;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.concurrent.duration.Duration$;
import coursierapi.shaded.scala.concurrent.duration.FiniteDuration;
import coursierapi.shaded.scala.concurrent.duration.package;
import coursierapi.shaded.scala.concurrent.duration.package$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.RichChar$;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Failure;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import coursierapi.shaded.scala.util.Success;
import coursierapi.shaded.scala.util.Try;
import coursierapi.shaded.scala.util.Try$;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.ExecutorService;

public final class CacheDefaults$ {
    public static final CacheDefaults$ MODULE$ = new CacheDefaults$();
    private static File location;
    private static int concurrentDownloadCount;
    private static ExecutorService pool;
    private static Option<Duration> ttl;
    private static int sslRetryCount;
    private static Option<Object> maxRedirections;
    private static final Seq<Option<String>> checksums;
    private static final int bufferSize;
    private static final Seq<CachePolicy.Mixed> noEnvCachePolicies;
    private static volatile byte bitmap$0;

    static {
        checksums = (Seq)coursierapi.shaded.scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some<String>("SHA-1"), None$.MODULE$}));
        bufferSize = 0x100000;
        noEnvCachePolicies = (Seq)coursierapi.shaded.scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CachePolicy.Mixed[]{CachePolicy$LocalUpdateChanging$.MODULE$, CachePolicy$LocalOnly$.MODULE$, CachePolicy$Update$.MODULE$}));
    }

    private File location$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                location = CachePath.defaultCacheDirectory();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return location;
    }

    public File location() {
        return (byte)(bitmap$0 & 1) == 0 ? this.location$lzycompute() : location;
    }

    private int defaultConcurrentDownloadCount() {
        return 6;
    }

    private int concurrentDownloadCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                concurrentDownloadCount = BoxesRunTime.unboxToInt(coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.parallel-download-count").flatMap((Function1<String, Option> & Serializable)s -> Try$.MODULE$.apply(() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)s))).toOption()).getOrElse(() -> MODULE$.defaultConcurrentDownloadCount()));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return concurrentDownloadCount;
    }

    public int concurrentDownloadCount() {
        return (byte)(bitmap$0 & 4) == 0 ? this.concurrentDownloadCount$lzycompute() : concurrentDownloadCount;
    }

    private ExecutorService pool$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                pool = Sync$.MODULE$.fixedThreadPool(this.concurrentDownloadCount());
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return pool;
    }

    public ExecutorService pool() {
        return (byte)(bitmap$0 & 8) == 0 ? this.pool$lzycompute() : pool;
    }

    public Either<Throwable, Duration> parseDuration(String s) {
        Right<Throwable, Duration> right;
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)) && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(CacheDefaults$.$anonfun$parseDuration$1(BoxesRunTime.unboxToChar(x$1))))) {
            right = coursierapi.shaded.scala.package$.MODULE$.Right().apply(Duration$.MODULE$.Zero());
        } else {
            Either either;
            Try try_ = Try$.MODULE$.apply((Function0<Duration> & Serializable)() -> Duration$.MODULE$.apply(s));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Duration s2 = (Duration)success.value();
                either = coursierapi.shaded.scala.package$.MODULE$.Right().apply(s2);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                either = coursierapi.shaded.scala.package$.MODULE$.Left().apply(t);
            } else {
                throw new MatchError(try_);
            }
            right = either;
        }
        return right;
    }

    private Option<Duration> ttl$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                Option fromEnv = Option$.MODULE$.apply(System.getenv("COURSIER_TTL")).flatMap((Function1<String, Option> & Serializable)x$2 -> MODULE$.parseDuration((String)x$2).toOption());
                ttl = fromEnv.orElse((Function0<Option> & Serializable)() -> CacheDefaults$.fromProps$1()).orElse((Function0<Some> & Serializable)() -> new Some<FiniteDuration>(CacheDefaults$.default$1()));
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return ttl;
    }

    public Option<Duration> ttl() {
        return (byte)(bitmap$0 & 0x10) == 0 ? this.ttl$lzycompute() : ttl;
    }

    public Seq<Option<String>> checksums() {
        return checksums;
    }

    private int defaultSslRetryCount() {
        return 3;
    }

    private int sslRetryCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                sslRetryCount = BoxesRunTime.unboxToInt(coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.sslexception-retry").flatMap((Function1<String, Option> & Serializable)s -> Try$.MODULE$.apply(() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)s))).toOption()).filter(x$4 -> x$4 >= 0).getOrElse(() -> MODULE$.defaultSslRetryCount()));
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return sslRetryCount;
    }

    public int sslRetryCount() {
        return (byte)(bitmap$0 & 0x20) == 0 ? this.sslRetryCount$lzycompute() : sslRetryCount;
    }

    private Option<Object> defaultMaxRedirections() {
        return Option$.MODULE$.apply(BoxesRunTime.boxToInteger(20));
    }

    private Option<Object> maxRedirections$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(bitmap$0 & 0x40) == 0) {
                maxRedirections = CacheDefaults$.prop$1("coursierapi.shaded.coursier.http.maxRedirects").orElse((Function0<Option> & Serializable)() -> CacheDefaults$.prop$1("http.maxRedirects")).orElse((Function0<Option> & Serializable)() -> MODULE$.defaultMaxRedirections());
                bitmap$0 = (byte)(bitmap$0 | 0x40);
            }
        }
        return maxRedirections;
    }

    public Option<Object> maxRedirections() {
        return (byte)(bitmap$0 & 0x40) == 0 ? this.maxRedirections$lzycompute() : maxRedirections;
    }

    public int defaultRetryCount() {
        return 1;
    }

    public int bufferSize() {
        return bufferSize;
    }

    private Option<String> credentialPropOpt() {
        return Option$.MODULE$.apply(System.getenv("COURSIER_CREDENTIALS")).orElse((Function0<Option> & Serializable)() -> coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.credentials")).map((Function1<String, String> & Serializable)s -> StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString((String)s), (Function1<Object, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(RichChar$.MODULE$.isSpaceChar$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar(x$6))))));
    }

    private boolean isPropFile(String s) {
        return s.startsWith("/") || s.startsWith("file:");
    }

    public Seq<Credentials> credentials() {
        Seq seq;
        if (this.credentialPropOpt().isEmpty()) {
            Seq configDirs = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps(CoursierPaths.configDirectories()));
            Seq mainCredentialsFiles = (Seq)configDirs.map((Function1<File, File> & Serializable)configDir -> new File((File)configDir, "credentials.properties"));
            Seq dirs = (Seq)configDirs.map((Function1<File, File> & Serializable)configDir -> new File((File)configDir, "credentials"));
            Seq files = (Seq)dirs.flatMap((Function1<File, Seq> & Serializable)dir2 -> {
                File[] listOrNull = dir2.listFiles((dir, name) -> !name.startsWith(".") && name.endsWith(".properties"));
                return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(listOrNull)).toSeq().flatten((Function1<File[], ArraySeq.ofRef> & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
            });
            Seq otherFiles = (Seq)((IterableOps)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(files)).toSeq().flatten(Predef$.MODULE$.$conforms())).map((Function1<File, FileCredentials> & Serializable)f -> FileCredentials$.MODULE$.apply(f.getAbsolutePath(), true));
            seq = (Seq)((IterableOps)mainCredentialsFiles.map((Function1<File, FileCredentials> & Serializable)f -> FileCredentials$.MODULE$.apply(f.getAbsolutePath(), true))).$plus$plus(otherFiles);
        } else {
            seq = (Seq)Option$.MODULE$.option2Iterable(this.credentialPropOpt()).toSeq().flatMap((Function1<String, IterableOnce> & Serializable)x0$1 -> {
                Object object;
                String string = x0$1;
                switch (string == null ? 0 : string.hashCode()) {
                    default: 
                }
                if (MODULE$.isPropFile(string)) {
                    String path0 = string.startsWith("file:") ? new File(new URI(string)).getAbsolutePath() : string;
                    object = coursierapi.shaded.scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FileCredentials[]{FileCredentials$.MODULE$.apply(path0, true)}));
                } else {
                    object = (IterableOnce)CredentialsParser$.MODULE$.parseSeq(string).either().toSeq().flatten(Predef$.MODULE$.$conforms());
                }
                IterableOnce iterableOnce = object;
                return iterableOnce;
            });
        }
        return seq;
    }

    public Seq<CachePolicy.Mixed> noEnvCachePolicies() {
        return noEnvCachePolicies;
    }

    public Seq<CachePolicy> cachePolicies() {
        Option fromEnv = CacheDefaults$.fromOption$1(Option$.MODULE$.apply(System.getenv("COURSIER_MODE")), "COURSIER_MODE environment variable");
        return (Seq)fromEnv.orElse((Function0<Option> & Serializable)() -> CacheDefaults$.fromProps$2()).getOrElse((Function0<Seq> & Serializable)() -> MODULE$.noEnvCachePolicies());
    }

    public static final /* synthetic */ boolean $anonfun$parseDuration$1(char x$1) {
        return x$1 == '0';
    }

    private static final Option fromProps$1() {
        return coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.ttl").flatMap((Function1<String, Option> & Serializable)x$3 -> MODULE$.parseDuration((String)x$3).toOption());
    }

    private static final FiniteDuration default$1() {
        return new package.DurationInt(package$.MODULE$.DurationInt(24)).hours();
    }

    private static final Option prop$1(String name) {
        return coursierapi.shaded.scala.sys.package$.MODULE$.props().get(name).flatMap((Function1<String, Option> & Serializable)s -> Try$.MODULE$.apply(() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)s))).toOption()).filter(x$5 -> x$5 >= 0);
    }

    private static final Option fromOption$1(Option value, String description) {
        return value.filter((Function1<String, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7)))).flatMap((Function1<String, Option> & Serializable)str -> {
            void var2_10;
            boolean bl = false;
            Right right = null;
            Either<$colon$colon<String>, Seq<CachePolicy>> either = CachePolicyParser$.MODULE$.cachePolicies((String)str, MODULE$.noEnvCachePolicies()).either();
            if (either instanceof Right) {
                SeqOps seqOps;
                bl = true;
                right = (Right)either;
                Seq seq = (Seq)right.value();
                if (seq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = coursierapi.shaded.scala.package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                    Console$.MODULE$.err().println(new StringBuilder(40).append("Warning: no mode found in ").append(description).append(", ignoring it.").toString());
                    None$ none$ = None$.MODULE$;
                    return var2_10;
                }
            }
            if (bl) {
                Seq policies = (Seq)right.value();
                Some<Seq> some = new Some<Seq>(policies);
                return var2_10;
            }
            if (!(either instanceof Left)) throw new MatchError(either);
            Console$.MODULE$.err().println(new StringBuilder(44).append("Warning: unrecognized mode in ").append(description).append(", ignoring it.").toString());
            None$ none$ = None$.MODULE$;
            return var2_10;
        });
    }

    private static final Option fromProps$2() {
        return CacheDefaults$.fromOption$1(coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.mode"), "Java property coursier.mode");
    }

    private CacheDefaults$() {
    }
}

