/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.Ranges;
import io.gatling.charts.util.Color;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00053Q!\u0003\u0006\u0001\u0019QA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\tQ\u0001\u0011\t\u0011)A\u00057!A\u0011\u0006\u0001B\u0001B\u0003%1\u0004\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\"\u0002\u001c\u0001\t\u00039\u0004\"\u0002 \u0001\t\u0003z\u0004\"\u0002!\u0001\t\u0003z$A\u0004*b]\u001e,7\u000fV3na2\fG/\u001a\u0006\u0003\u00171\t\u0001\u0002^3na2\fG/\u001a\u0006\u0003\u001b9\t!\u0002[5hQ\u000eD\u0017M\u001d;t\u0015\ty\u0001#\u0001\u0004dQ\u0006\u0014Ho\u001d\u0006\u0003#I\tqaZ1uY&twMC\u0001\u0014\u0003\tIwn\u0005\u0002\u0001+A\u0011acF\u0007\u0002\u0015%\u0011\u0001D\u0003\u0002\t)\u0016l\u0007\u000f\\1uK\u0006Y1m\u001c8uC&tWM]%e\u0007\u0001\u0001\"\u0001H\u0013\u000f\u0005u\u0019\u0003C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u001b\u0003\u0019a$o\\8u})\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!\u0013%\u0001\u0006dQ\u0006\u0014H\u000fV5uY\u0016\f\u0011\"\u001a<f]Rt\u0015-\\3\u0002\rI\fgnZ3t!\tas&D\u0001.\u0015\tqc\"A\u0003ti\u0006$8/\u0003\u00021[\t1!+\u00198hKN\fQ\u0001\\1sO\u0016\u0004\"a\r\u001b\u000e\u0003\u0005J!!N\u0011\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"b\u0001O\u001d;wqj\u0004C\u0001\f\u0001\u0011\u0015Ib\u00011\u0001\u001c\u0011\u0015Ac\u00011\u0001\u001c\u0011\u0015Ic\u00011\u0001\u001c\u0011\u0015Qc\u00011\u0001,\u0011\u0015\td\u00011\u00013\u0003\tQ7/F\u0001\u001c\u0003\u0011AG/\u001c7")
public class RangesTemplate
extends Template {
    private final String containerId;
    private final String chartTitle;
    private final String eventName;
    private final Ranges ranges;
    private final boolean large;

    @Override
    public String js() {
        return "\nHighcharts.setOptions({\n  global: { useUTC: false }\n});\n\nnew Highcharts.Chart({\n  chart: {\n    renderTo: '" + this.containerId + "',\n    marginRight: 100\n  },\n  credits: { enabled: false },\n  legend: { enabled: false },\n  title: {\n    text: '<span class=\"chart_title\">" + this.chartTitle + "</span>',\n    useHTML: true\n  },\n  xAxis: {\n    categories: [\n      \"t < " + this.ranges.lowerBound() + " ms\",\n      \"t >= " + this.ranges.lowerBound() + " ms <br> t < " + this.ranges.higherBound() + " ms\",\n      \"t >= " + this.ranges.higherBound() + " ms\",\n      \"failed\"\n    ]\n  },\n  yAxis: {\n    title: { text: 'Number of " + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(this.eventName)) + "' },\n    reversedStacks: false\n  },\n  tooltip: {\n    formatter: function() {\n      var s;\n      if (this.point.name) { // the pie chart\n        s = ''+ this.point.name +': '+ this.y +'% " + this.eventName + "';\n      } else {\n        s = ''+ this.y + ' " + this.eventName + "';\n      }\n      return s;\n    }\n  },\n  plotOptions: {\n    series: {\n      stacking: 'normal',\n      shadow: true\n    }\n  },\n  series: [\n    {\n      type: 'column',\n      data: [{\n      \tcolor: '" + Color.Requests$.MODULE$.Ok() + "',\n      \ty: " + this.ranges.lowCount() + "\n      },\n      {\n      \tcolor: '" + Color.Requests$.MODULE$.Fine() + "',\n      \ty: " + this.ranges.middleCount() + "\n      },\n      {\n      \tcolor: '" + Color.Requests$.MODULE$.Poor() + "',\n      \ty: " + this.ranges.highCount() + "\n      },\n      {\n      \tcolor: '" + Color.Requests$.MODULE$.Ko() + "',\n      \ty: " + this.ranges.koCount() + "\n      }]\n    },\n    {\n      type: 'pie',\n      name: 'Percentages',\n      data: [\n        {\n          name: \"t < " + this.ranges.lowerBound() + " ms\",\n          y: " + this.ranges.lowPercentage() + ",\n          color: '" + Color.Requests$.MODULE$.Ok() + "'\n        },\n        {\n          name: \"" + this.ranges.lowerBound() + " ms <= t < " + this.ranges.higherBound() + " ms\",\n          y: " + this.ranges.middlePercentage() + ",\n          color: '" + Color.Requests$.MODULE$.Fine() + "'\n        },\n        {\n          name: \"t >= " + this.ranges.higherBound() + " ms\",\n          y: " + this.ranges.highPercentage() + ",\n          color: '" + Color.Requests$.MODULE$.Poor() + "'\n        },\n        {\n          name: \"failed\",\n          y: " + this.ranges.koPercentage() + ",\n          color: '" + Color.Requests$.MODULE$.Ko() + "'\n        }\n      ],\n      center: [" + (this.large ? "368" : "345") + ", 0],\n      size: 90,\n      showInLegend: false,\n      dataLabels: { enabled: false }\n    }\n  ]\n});\n";
    }

    @Override
    public String html() {
        return "\n            <div id=\"" + this.containerId + "\" class=\"schema " + (this.large ? "ranges-large" : "ranges") + "\">\n            </div>\n";
    }

    public RangesTemplate(String containerId, String chartTitle, String eventName, Ranges ranges, boolean large) {
        this.containerId = containerId;
        this.chartTitle = chartTitle;
        this.eventName = eventName;
        this.ranges = ranges;
        this.large = large;
    }
}

