/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.controller;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.core.filter.Filters$;
import io.gatling.http.client.uri.Uri;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Har$;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.http.mitm.Mitm;
import io.gatling.recorder.http.mitm.Mitm$;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.gatling.recorder.render.HttpTraffic;
import io.gatling.recorder.render.HttpTraffic$;
import io.gatling.recorder.render.HttpTrafficConverter;
import io.gatling.recorder.render.RequestElement;
import io.gatling.recorder.render.RequestElement$;
import io.gatling.recorder.render.TagElement;
import io.gatling.recorder.render.TimedScenarioElement;
import io.gatling.recorder.ui.PauseFrontEndEvent;
import io.gatling.recorder.ui.RecorderFrontEnd;
import io.gatling.recorder.ui.RecorderFrontEnd$;
import io.gatling.recorder.ui.RequestFrontEndEvent;
import io.gatling.recorder.ui.SslFrontEndEvent;
import io.gatling.recorder.ui.TagFrontEndEvent;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd!B\u000b\u0017\u0005aq\u0002\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000be\u0002A\u0011\u0001\u001e\t\u000fy\u0002!\u0019!C\u0005\u007f!1a\t\u0001Q\u0001\n\u0001C\u0011b\u0012\u0001A\u0002\u0003\u0007I\u0011\u0002%\t\u0013A\u0003\u0001\u0019!a\u0001\n\u0013\t\u0006\"C,\u0001\u0001\u0004\u0005\t\u0015)\u0003J\u0011%A\u0006\u00011AA\u0002\u0013%\u0011\fC\u0005a\u0001\u0001\u0007\t\u0019!C\u0005C\"I1\r\u0001a\u0001\u0002\u0003\u0006KA\u0017\u0005\bI\u0002\u0011\r\u0011\"\u0003f\u0011\u0019)\b\u0001)A\u0005M\"9a\u000f\u0001b\u0001\n\u00139\bBB?\u0001A\u0003%\u0001\u0010C\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA&\u0001\u0011\u0005\u0011Q\n\u0005\u0007\u0003K\u0002A\u0011A@\u0003%I+7m\u001c:eKJ\u001cuN\u001c;s_2dWM\u001d\u0006\u0003/a\t!bY8oiJ|G\u000e\\3s\u0015\tI\"$\u0001\u0005sK\u000e|'\u000fZ3s\u0015\tYB$A\u0004hCRd\u0017N\\4\u000b\u0003u\t!![8\u0014\u0007\u0001yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M5j\u0011a\n\u0006\u0003Q%\nAb]2bY\u0006dwnZ4j]\u001eT!AK\u0016\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001L\u0001\u0004G>l\u0017B\u0001\u0018(\u00055\u0019FO]5di2{wmZ5oO\u0006)1\r\\8dW\u000e\u0001\u0001C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011)H/\u001b7\u000b\u0005YR\u0012aB2p[6|gn]\u0005\u0003qM\u0012Qa\u00117pG.\fa\u0001P5oSRtDCA\u001e>!\ta\u0004!D\u0001\u0017\u0011\u0015y#\u00011\u00012\u0003!1'o\u001c8u\u000b:$W#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rC\u0012AA;j\u0013\t)%I\u0001\tSK\u000e|'\u000fZ3s\rJ|g\u000e^#oI\u0006IaM]8oi\u0016sG\rI\u0001\u0005[&$X.F\u0001J!\tQe*D\u0001L\u0015\t9EJ\u0003\u0002N1\u0005!\u0001\u000e\u001e;q\u0013\ty5J\u0001\u0003NSRl\u0017\u0001C7ji6|F%Z9\u0015\u0005I+\u0006C\u0001\u0011T\u0013\t!\u0016E\u0001\u0003V]&$\bb\u0002,\u0007\u0003\u0003\u0005\r!S\u0001\u0004q\u0012\n\u0014!B7ji6\u0004\u0013!C2p]Z,'\u000f^3s+\u0005Q\u0006CA._\u001b\u0005a&BA/\u0019\u0003\u0019\u0011XM\u001c3fe&\u0011q\f\u0018\u0002\u0015\u0011R$\b\u000f\u0016:bM\u001aL7mQ8om\u0016\u0014H/\u001a:\u0002\u001b\r|gN^3si\u0016\u0014x\fJ3r)\t\u0011&\rC\u0004W\u0013\u0005\u0005\t\u0019\u0001.\u0002\u0015\r|gN^3si\u0016\u0014\b%\u0001\u0005sKF,Xm\u001d;t+\u00051\u0007cA4n_6\t\u0001N\u0003\u0002jU\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005QZ'\"\u00017\u0002\t)\fg/Y\u0005\u0003]\"\u0014QcQ8oGV\u0014(/\u001a8u\u0019&t7.\u001a3Rk\u0016,X\rE\u0002\\aJL!!\u001d/\u0003)QKW.\u001a3TG\u0016t\u0017M]5p\u000b2,W.\u001a8u!\tY6/\u0003\u0002u9\nq!+Z9vKN$X\t\\3nK:$\u0018!\u0003:fcV,7\u000f^:!\u0003\u0011!\u0018mZ:\u0016\u0003a\u00042aZ7z!\rY\u0006O\u001f\t\u00037nL!\u0001 /\u0003\u0015Q\u000bw-\u00127f[\u0016tG/A\u0003uC\u001e\u001c\b%\u0001\bti\u0006\u0014HOU3d_J$\u0017N\\4\u0015\u0003I\u000bQb\u001d;paJ+7m\u001c:eS:<Gc\u0001*\u0002\u0006!9\u0011q\u0001\tA\u0002\u0005%\u0011\u0001B:bm\u0016\u00042\u0001IA\u0006\u0013\r\ti!\t\u0002\b\u0005>|G.Z1o\u0003=\u0011XmY3jm\u0016\u0014Vm\u001d9p]N,G#\u0002*\u0002\u0014\u0005\r\u0002bBA\u000b#\u0001\u0007\u0011qC\u0001\be\u0016\fX/Z:u!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f1\u0005)Qn\u001c3fY&!\u0011\u0011EA\u000e\u0005-AE\u000f\u001e9SKF,Xm\u001d;\t\u000f\u0005\u0015\u0012\u00031\u0001\u0002(\u0005A!/Z:q_:\u001cX\r\u0005\u0003\u0002\u001a\u0005%\u0012\u0002BA\u0016\u00037\u0011A\u0002\u0013;uaJ+7\u000f]8og\u0016\fa!\u00193e)\u0006<Gc\u0001*\u00022!9\u00111\u0007\nA\u0002\u0005U\u0012\u0001\u0002;fqR\u0004B!a\u000e\u0002F9!\u0011\u0011HA!!\r\tY$I\u0007\u0003\u0003{Q1!a\u00101\u0003\u0019a$o\\8u}%\u0019\u00111I\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\t9%!\u0013\u0003\rM#(/\u001b8h\u0015\r\t\u0019%I\u0001\u0011g\u0016\u001cWO]3D_:tWm\u0019;j_:$2AUA(\u0011\u001d\t\tf\u0005a\u0001\u0003'\nab]3dkJ,G\rS8tiV\u0013\u0016\n\u0005\u0003\u0002V\u0005\u0005TBAA,\u0015\u0011\tI&a\u0017\u0002\u0007U\u0014\u0018N\u0003\u0003\u0002^\u0005}\u0013AB2mS\u0016tGO\u0003\u0002N5%!\u00111MA,\u0005\r)&/[\u0001\u0013G2,\u0017M\u001d*fG>\u0014H-\u001a:Ti\u0006$X\r")
public final class RecorderController
implements StrictLogging {
    private final Clock clock;
    private final RecorderFrontEnd frontEnd;
    private Mitm mitm;
    private HttpTrafficConverter converter;
    private final ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests;
    private final ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private RecorderFrontEnd frontEnd() {
        return this.frontEnd;
    }

    private Mitm mitm() {
        return this.mitm;
    }

    private void mitm_$eq(Mitm x$1) {
        this.mitm = x$1;
    }

    private HttpTrafficConverter converter() {
        return this.converter;
    }

    private void converter_$eq(HttpTrafficConverter x$1) {
        this.converter = x$1;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests() {
        return this.requests;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags() {
        return this.tags;
    }

    public void startRecording() {
        boolean proceed;
        RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
        this.converter_$eq(new HttpTrafficConverter(config));
        RecorderMode selectedMode = this.frontEnd().selectedRecorderMode();
        Path harFile = this.frontEnd().harFilePath();
        RecorderMode recorderMode = selectedMode;
        RecorderMode$Har$ recorderMode$Har$ = RecorderMode$Har$.MODULE$;
        if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Har$) : recorderMode$Har$ != null) && !Files.exists(harFile, new LinkOption[0])) {
            this.frontEnd().handleMissingHarFile(harFile);
            return;
        }
        boolean bl = proceed = this.converter().simulationFileExists() ? this.frontEnd().askSimulationOverwrite() : true;
        if (proceed) {
            RecorderMode recorderMode2 = selectedMode;
            if (RecorderMode$Har$.MODULE$.equals(recorderMode2)) {
                Validation<BoxedUnit> validation = this.converter().renderHarFile(harFile);
                if (validation instanceof Failure) {
                    Failure failure = (Failure)validation;
                    String errMsg = failure.message();
                    this.frontEnd().handleHarExportFailure(errMsg);
                } else {
                    this.frontEnd().handleHarExportSuccess();
                }
                return;
            }
            if (RecorderMode$Proxy$.MODULE$.equals(recorderMode2)) {
                this.mitm_$eq(Mitm$.MODULE$.apply(this, this.clock, config));
                this.frontEnd().recordingStarted();
                return;
            }
            throw new MatchError((Object)recorderMode2);
        }
    }

    public void stopRecording(boolean save) {
        try {
            this.frontEnd().recordingStopped();
            if (save) {
                if (this.requests().isEmpty()) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Nothing was recorded, skipping Simulation generation");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
                    HttpTraffic traffic = HttpTraffic$.MODULE$.apply((List<TimedScenarioElement<RequestElement>>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.requests()).asScala().toList(), (List<TimedScenarioElement<TagElement>>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.tags()).asScala().toList(), config);
                    this.converter().renderHttpTraffic(traffic);
                }
            }
        }
        finally {
            this.mitm().shutdown();
            this.clearRecorderState();
            this.frontEnd().init();
        }
    }

    public void receiveResponse(HttpRequest request, HttpResponse response) {
        RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
        if (config.filters().filters().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.accept(request.uri()))) && Filters$.MODULE$.BrowserNoiseFilters().accept(request.uri())) {
            this.requests().add(new TimedScenarioElement<RequestElement>(request.timestamp(), response.timestamp(), RequestElement$.MODULE$.apply(request, response, config)));
            Option previousSendTime = CollectionConverters$.MODULE$.CollectionHasAsScala(this.requests()).asScala().lastOption().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.sendTime()));
            previousSendTime.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)t -> {
                FiniteDuration delta = new package.DurationLong(package$.MODULE$.DurationLong(response.timestamp() - t)).milliseconds();
                if (delta.$greater((Object)config.core().thresholdForPauseCreation())) {
                    this.frontEnd().receiveEvent(new PauseFrontEndEvent(delta));
                    return;
                }
            });
            this.frontEnd().receiveEvent(new RequestFrontEndEvent(request, response, config));
            return;
        }
    }

    public void addTag(String text) {
        long now = this.clock.nowMillis();
        this.tags().add(new TimedScenarioElement<TagElement>(now, now, new TagElement(text)));
        this.frontEnd().receiveEvent(new TagFrontEndEvent(text));
    }

    public void secureConnection(Uri securedHostURI) {
        this.frontEnd().receiveEvent(new SslFrontEndEvent(securedHostURI.toUrl()));
    }

    public void clearRecorderState() {
        this.requests().clear();
        this.tags().clear();
    }

    public RecorderController(Clock clock) {
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.frontEnd = RecorderFrontEnd$.MODULE$.newFrontend(this, RecorderConfiguration$.MODULE$.recorderConfiguration());
        this.requests = new ConcurrentLinkedQueue();
        this.tags = new ConcurrentLinkedQueue();
        this.frontEnd().init();
        Statics.releaseFence();
    }
}

