/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.polling;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.Validation$;
import io.gatling.core.CoreComponents;
import io.gatling.core.action.Action;
import io.gatling.core.action.ChainableAction;
import io.gatling.core.action.ExitableAction;
import io.gatling.core.session.Session;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.util.NameGen;
import io.gatling.http.action.polling.Poller;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.engine.tx.HttpTxExecutor;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.request.HttpRequestDef;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001B\t\u0013\u0001uA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\t{\u0001\u0011\t\u0011)A\u0005}!Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\"\u001b\u0001\u0003\u0006\u0004%\tA\u001b\u0005\t]\u0002\u0011\t\u0011)A\u0005W\")q\u000e\u0001C\u0001a\"91\u0010\u0001b\u0001\n\u0003b\bBB?\u0001A\u0003%!\u0007C\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"!9\u0011\u0011\u0007\u0001\u0005B\u0005M\"\u0001\u0004)pY2LgnZ*uCJ$(BA\n\u0015\u0003\u001d\u0001x\u000e\u001c7j]\u001eT!!\u0006\f\u0002\r\u0005\u001cG/[8o\u0015\t9\u0002$\u0001\u0003iiR\u0004(BA\r\u001b\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aG\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001=\u0011Z\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002&S5\taE\u0003\u0002\u0016O)\u0011\u0001\u0006G\u0001\u0005G>\u0014X-\u0003\u0002+M\tqQ\t_5uC\ndW-Q2uS>t\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018(\u0003\u0011)H/\u001b7\n\u0005Aj#a\u0002(b[\u0016<UM\\\u0001\u000ba>dG.\u001a:OC6,\u0007CA\u001a;\u001d\t!\u0004\b\u0005\u00026A5\taG\u0003\u000289\u00051AH]8pizJ!!\u000f\u0011\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003s\u0001\na\u0001]3sS>$\u0007CA E\u001b\u0005\u0001%BA!C\u0003!!WO]1uS>t'BA\"!\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u000b\u0002\u0013aBR5oSR,G)\u001e:bi&|g.\u0001\bd_J,7i\\7q_:,g\u000e^:\u0011\u0005!KU\"A\u0014\n\u0005);#AD\"pe\u0016\u001cu.\u001c9p]\u0016tGo]\u0001\u000fQR$\bOU3rk\u0016\u001cH\u000fR3g!\ti\u0005+D\u0001O\u0015\tye#A\u0004sKF,Xm\u001d;\n\u0005Es%A\u0004%uiB\u0014V-];fgR$UMZ\u0001\u000bQR$\boQ1dQ\u0016\u001c\bC\u0001+X\u001b\u0005)&B\u0001,\u0017\u0003\u0015\u0019\u0017m\u00195f\u0013\tAVK\u0001\u0006IiR\u00048)Y2iKN\fA\u0002\u001b;uaB\u0013x\u000e^8d_2\u0004\"a\u00170\u000e\u0003qS!!\u0018\f\u0002\u0011A\u0014x\u000e^8d_2L!a\u0018/\u0003\u0019!#H\u000f\u001d)s_R|7m\u001c7\u0002\u001d!$H\u000f\u001d+y\u000bb,7-\u001e;peB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0003ibT!A\u001a\f\u0002\r\u0015tw-\u001b8f\u0013\tA7M\u0001\bIiR\u0004H\u000b_#yK\u000e,Ho\u001c:\u0002\t9,\u0007\u0010^\u000b\u0002WB\u0011Q\u0005\\\u0005\u0003[\u001a\u0012a!Q2uS>t\u0017!\u00028fqR\u0004\u0013A\u0002\u001fj]&$h\bF\u0005rgR,ho\u001e=zuB\u0011!\u000fA\u0007\u0002%!)\u0011G\u0003a\u0001e!)QH\u0003a\u0001}!)aI\u0003a\u0001\u000f\")1J\u0003a\u0001\u0019\")!K\u0003a\u0001'\")\u0011L\u0003a\u00015\")\u0001M\u0003a\u0001C\")\u0011N\u0003a\u0001W\u0006!a.Y7f+\u0005\u0011\u0014!\u00028b[\u0016\u0004\u0013!B2m_\u000e\\WCAA\u0001!\u0011\t\u0019!a\u0003\u000e\u0005\u0005\u0015!b\u0001\u0018\u0002\b)\u0019\u0011\u0011\u0002\r\u0002\u000f\r|W.\\8og&!\u0011QBA\u0003\u0005\u0015\u0019En\\2l\u0003-\u0019H/\u0019;t\u000b:<\u0017N\\3\u0016\u0005\u0005M\u0001\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005eq%A\u0003ti\u0006$8/\u0003\u0003\u0002\u001e\u0005]!aC*uCR\u001cXI\\4j]\u0016\f1b\u001d;beR\u0004v\u000e\u001c7feR!\u00111EA\u0018!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015O\u000591/Z:tS>t\u0017\u0002BA\u0017\u0003O\u0011qaU3tg&|g\u000eC\u0004\u0002*=\u0001\r!a\t\u0002\u000f\u0015DXmY;uKR!\u0011QGA\u001e!\ry\u0012qG\u0005\u0004\u0003s\u0001#\u0001B+oSRDq!!\u000b\u0011\u0001\u0004\t\u0019\u0003")
public class PollingStart
implements ExitableAction,
NameGen {
    private final String pollerName;
    private final FiniteDuration period;
    private final CoreComponents coreComponents;
    private final HttpRequestDef httpRequestDef;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final HttpTxExecutor httpTxExecutor;
    private final Action next;
    private final String name;
    private Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public /* synthetic */ void io$gatling$core$action$ExitableAction$$super$$bang(Session session) {
        ChainableAction.$bang$((ChainableAction)this, (Session)session);
    }

    public void $bang(Session session) {
        ExitableAction.$bang$((ExitableAction)this, (Session)session);
    }

    public /* synthetic */ void io$gatling$core$action$ChainableAction$$super$$bang(Session session) {
        Action.$bang$((Action)this, (Session)session);
    }

    public void recover(Session session, Validation<?> v) {
        ChainableAction.recover$((ChainableAction)this, (Session)session, v);
    }

    public String toString() {
        return Action.toString$((Action)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Action next() {
        return this.next;
    }

    public String name() {
        return this.name;
    }

    public Clock clock() {
        return this.coreComponents.clock();
    }

    public StatsEngine statsEngine() {
        return this.coreComponents.statsEngine();
    }

    private Session startPoller(Session session) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Starting poller {}", (Object)this.pollerName);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Poller poller = new Poller(this.pollerName, this.period, this.httpRequestDef, this.httpTxExecutor, this.httpCaches, this.httpProtocol, this.statsEngine());
        Session newSession = session.set(this.pollerName, (Object)poller);
        poller.start(newSession);
        return newSession;
    }

    public void execute(Session session) {
        Failure failure;
        if (session.contains(this.pollerName)) {
            failure = new Failure(new StringBuilder(56).append("Unable to create a new poller with name ").append(this.pollerName).append(": already exists").toString());
        } else {
            Session newSession = this.startPoller(session);
            this.next().$bang(newSession);
            failure = Validation$.MODULE$.unit();
        }
        this.recover(session, (Validation<?>)failure);
    }

    public PollingStart(String pollerName, FiniteDuration period, CoreComponents coreComponents, HttpRequestDef httpRequestDef, HttpCaches httpCaches, HttpProtocol httpProtocol, HttpTxExecutor httpTxExecutor, Action next) {
        this.pollerName = pollerName;
        this.period = period;
        this.coreComponents = coreComponents;
        this.httpRequestDef = httpRequestDef;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.httpTxExecutor = httpTxExecutor;
        this.next = next;
        StrictLogging.$init$((StrictLogging)this);
        Action.$init$((Action)this);
        ChainableAction.$init$((ChainableAction)this);
        ExitableAction.$init$((ExitableAction)this);
        NameGen.$init$((NameGen)this);
        this.name = this.genName(pollerName);
        Statics.releaseFence();
    }
}

