/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.cache;

import io.gatling.commons.util.Clock;
import io.gatling.http.cache.ExpiresSupport$;
import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005q<Qa\u0004\t\t\u0002e1Qa\u0007\t\t\u0002qAQaI\u0001\u0005\u0002\u0011Ba!J\u0001\u0005\u0002A1c\u0001C\u000e\u0011!\u0003\r\t\u0001\u0005\u001f\t\u000bu\"A\u0011\u0001 \t\u000b\t#a\u0011A\"\t\u000f1#!\u0019!C\u0005\u001b\"9Q\u000b\u0002b\u0001\n\u0013i\u0005\"\u0002,\u0005\t\u00039\u0006\"\u0002/\u0005\t\u0003i\u0006\"\u00021\u0005\t\u0013\t\u0007\"B4\u0005\t\u0013A\u0007\"\u00026\u0005\t\u0013Y\u0007\"B=\u0005\t\u0003Q\u0018AD#ya&\u0014Xm]*vaB|'\u000f\u001e\u0006\u0003#I\tQaY1dQ\u0016T!a\u0005\u000b\u0002\t!$H\u000f\u001d\u0006\u0003+Y\tqaZ1uY&twMC\u0001\u0018\u0003\tIwn\u0001\u0001\u0011\u0005i\tQ\"\u0001\t\u0003\u001d\u0015C\b/\u001b:fgN+\b\u000f]8siN\u0011\u0011!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0012\u0001E3yiJ\f7\r\u001e'p]\u001e4\u0016\r\\;f)\r9#f\u000e\t\u0003=!J!!K\u0010\u0003\t1{gn\u001a\u0005\u0006W\r\u0001\r\u0001L\u0001\u0002gB\u0011Q\u0006\u000e\b\u0003]I\u0002\"aL\u0010\u000e\u0003AR!!\r\r\u0002\rq\u0012xn\u001c;?\u0013\t\u0019t$\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a \u0011\u0015A4\u00011\u0001:\u0003\u0015\u0019H/\u0019:u!\tq\"(\u0003\u0002<?\t\u0019\u0011J\u001c;\u0014\u0005\u0011i\u0012A\u0002\u0013j]&$H\u0005F\u0001@!\tq\u0002)\u0003\u0002B?\t!QK\\5u\u0003\u0015\u0019Gn\\2l+\u0005!\u0005CA#K\u001b\u00051%BA$I\u0003\u0011)H/\u001b7\u000b\u0005%#\u0012aB2p[6|gn]\u0005\u0003\u0017\u001a\u0013Qa\u00117pG.\fA\"T1y\u0003\u001e,\u0007K]3gSb,\u0012A\u0014\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000bA\u0001\\1oO*\t1+\u0001\u0003kCZ\f\u0017BA\u001bQ\u0003)i\u0015\r_!hKj+'o\\\u0001\u0013Kb$(/Y2u\u001b\u0006D\u0018iZ3WC2,X\r\u0006\u0002Y7B\u0019a$W\u0014\n\u0005i{\"AB(qi&|g\u000eC\u0003,\u0013\u0001\u0007A&A\nfqR\u0014\u0018m\u0019;FqBL'/Z:WC2,X\r\u0006\u0002Y=\")qL\u0003a\u0001Y\u0005QA/[7fgR\u0014\u0018N\\4\u0002'\r\f7\r[3D_:$(o\u001c7O_\u000e\u000b7\r[3\u0015\u0005\t,\u0007C\u0001\u0010d\u0013\t!wDA\u0004C_>dW-\u00198\t\u000b\u0019\\\u0001\u0019\u0001\u0017\u0002%\r\f7\r[3D_:$(o\u001c7IK\u0006$WM]\u0001\u0015[\u0006D\u0018iZ3Bg\u0016C\b/\u001b:fgZ\u000bG.^3\u0015\u0005aK\u0007\"\u00024\r\u0001\u0004a\u0013\u0001D3ya&\u0014Xm\u001d,bYV,GC\u0001-m\u0011\u0015iW\u00021\u0001o\u0003=\u0011Xm\u001d9p]N,\u0007*Z1eKJ\u001c\bCA8x\u001b\u0005\u0001(BA\nr\u0015\t\u00118/A\u0003d_\u0012,7M\u0003\u0002uk\u00069\u0001.\u00198eY\u0016\u0014(B\u0001<\u0017\u0003\u0015qW\r\u001e;z\u0013\tA\bOA\u0006IiR\u0004\b*Z1eKJ\u001c\u0018AE4fiJ+7\u000f]8og\u0016,\u0005\u0010]5sKN$\"\u0001W>\t\u000b5t\u0001\u0019\u00018")
public interface ExpiresSupport {
    public void io$gatling$http$cache$ExpiresSupport$_setter_$io$gatling$http$cache$ExpiresSupport$$MaxAgePrefix_$eq(String var1);

    public void io$gatling$http$cache$ExpiresSupport$_setter_$io$gatling$http$cache$ExpiresSupport$$MaxAgeZero_$eq(String var1);

    public Clock clock();

    public String io$gatling$http$cache$ExpiresSupport$$MaxAgePrefix();

    public String io$gatling$http$cache$ExpiresSupport$$MaxAgeZero();

    public static /* synthetic */ Option extractMaxAgeValue$(ExpiresSupport $this, String s) {
        return $this.extractMaxAgeValue(s);
    }

    default public Option<Object> extractMaxAgeValue(String s) {
        int index = s.indexOf(this.io$gatling$http$cache$ExpiresSupport$$MaxAgePrefix());
        int start = this.io$gatling$http$cache$ExpiresSupport$$MaxAgePrefix().length() + index;
        if (index >= 0 && start <= s.length()) {
            char c = s.charAt(start);
            switch (c) {
                case '-': {
                    return new Some((Object)BoxesRunTime.boxToLong((long)-1L));
                }
            }
            if (RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(c))) {
                return new Some((Object)BoxesRunTime.boxToLong((long)ExpiresSupport$.MODULE$.extractLongValue(s, start)));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public static /* synthetic */ Option extractExpiresValue$(ExpiresSupport $this, String timestring) {
        return $this.extractExpiresValue(timestring);
    }

    default public Option<Object> extractExpiresValue(String timestring) {
        String trimmedTimeString = ExpiresSupport.removeQuote$1(timestring.trim());
        return Option$.MODULE$.apply((Object)DateFormatter.parseHttpDate((CharSequence)trimmedTimeString)).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getTime()));
    }

    private boolean cacheControlNoCache(String cacheControlHeader) {
        return cacheControlHeader.contains(HttpHeaderValues.NO_CACHE.toString()) || cacheControlHeader.contains(HttpHeaderValues.NO_STORE.toString()) || cacheControlHeader.contains(this.io$gatling$http$cache$ExpiresSupport$$MaxAgeZero());
    }

    private Option<Object> maxAgeAsExpiresValue(String cacheControlHeader) {
        return this.extractMaxAgeValue(cacheControlHeader).flatMap((Function1 & Serializable)maxAge -> ExpiresSupport.$anonfun$maxAgeAsExpiresValue$1(this, BoxesRunTime.unboxToLong((Object)maxAge)));
    }

    private Option<Object> expiresValue(HttpHeaders responseHeaders) {
        String expiresHeader = responseHeaders.get((CharSequence)HttpHeaderNames.EXPIRES);
        if (expiresHeader != null) {
            return this.extractExpiresValue(expiresHeader).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$2 -> x$2 > this.clock().nowMillis());
        }
        return None$.MODULE$;
    }

    public static /* synthetic */ Option getResponseExpires$(ExpiresSupport $this, HttpHeaders responseHeaders) {
        return $this.getResponseExpires(responseHeaders);
    }

    default public Option<Object> getResponseExpires(HttpHeaders responseHeaders) {
        String pragmaHeader = responseHeaders.get((CharSequence)HttpHeaderNames.PRAGMA);
        if (pragmaHeader != null && pragmaHeader.contains(HttpHeaderValues.NO_CACHE.toString())) {
            return None$.MODULE$;
        }
        String cacheControlHeader = responseHeaders.get((CharSequence)HttpHeaderNames.CACHE_CONTROL);
        if (cacheControlHeader != null && this.cacheControlNoCache(cacheControlHeader)) {
            return None$.MODULE$;
        }
        if (cacheControlHeader != null) {
            return this.maxAgeAsExpiresValue(cacheControlHeader);
        }
        return this.expiresValue(responseHeaders);
    }

    private static String removeQuote$1(String s) {
        int end;
        int start;
        block2: {
            if (s.isEmpty()) {
                return s;
            }
            start = 0;
            end = s.length();
            if (s.charAt(0) == '\"') {
                ++start;
            }
            if (s.charAt(s.length() - 1) != '\"') break block2;
            --end;
        }
        return s.substring(start, end);
    }

    public static /* synthetic */ Option $anonfun$maxAgeAsExpiresValue$1(ExpiresSupport $this, long maxAge) {
        if (maxAge < 0L) {
            return None$.MODULE$;
        }
        long updatedMaxAge = maxAge * 1000L + $this.clock().nowMillis();
        if (updatedMaxAge < 0L) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)(maxAge * 1000L + $this.clock().nowMillis())));
    }

    public static void $init$(ExpiresSupport $this) {
        $this.io$gatling$http$cache$ExpiresSupport$_setter_$io$gatling$http$cache$ExpiresSupport$$MaxAgePrefix_$eq("max-age=");
        $this.io$gatling$http$cache$ExpiresSupport$_setter_$io$gatling$http$cache$ExpiresSupport$$MaxAgeZero_$eq($this.io$gatling$http$cache$ExpiresSupport$$MaxAgePrefix() + "0");
    }
}

