/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http.api;

import io.gatling.plugin.io.PluginLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JulHttpLogging {
    private JulHttpLogging() {
    }

    public static void pipeTo(PluginLogger pluginLogger) {
        Logger logger = Logger.getLogger("sun.net.www.protocol.http.HttpURLConnection");
        logger.addHandler(new PluginLoggerHandler(pluginLogger));
        logger.setLevel(Level.ALL);
        LogManager.getLogManager().addLogger(logger);
    }

    private static final class PluginLoggerHandler
    extends Handler {
        private final PluginLogger pluginlogger;
        private static final Pattern MESSAGE_HEADER_DATA_PATTERN = Pattern.compile("\\{[^}]*}");
        private static final Pattern COOKIE_PATTERN = Pattern.compile("[^,\\] ]{2,}");

        private PluginLoggerHandler(PluginLogger pluginLogger) {
            this.pluginlogger = pluginLogger;
        }

        @Override
        public void publish(LogRecord logRecord) {
            StringBuilder stringBuilder = new StringBuilder().append(logRecord.getInstant()).append(" ").append(logRecord.getLevel()).append(" ").append(logRecord.getSourceClassName()).append("#").append(logRecord.getSourceMethodName()).append(" ");
            this.appendMessage(stringBuilder, logRecord.getMessage());
            if (logRecord.getThrown() != null) {
                StringWriter stringWriter = new StringWriter();
                logRecord.getThrown().printStackTrace(new PrintWriter(stringWriter));
                stringBuilder.append(stringWriter);
            }
            this.pluginlogger.debug(stringBuilder.toString());
        }

        private void appendMessage(StringBuilder stringBuilder, String string) {
            stringBuilder.append("HTTP: ");
            if (string.startsWith("sun.net.www.MessageHeader@")) {
                stringBuilder.append('\n');
                Matcher matcher = MESSAGE_HEADER_DATA_PATTERN.matcher(string);
                boolean bl = true;
                while (matcher.find()) {
                    int n;
                    int n2 = matcher.start();
                    String string2 = string.substring(n2 + 1, (n = matcher.end()) - 1);
                    if (string2.startsWith("null: ")) {
                        string2 = string2.substring(6);
                    }
                    if (string2.endsWith(": null")) {
                        string2 = string2.substring(0, string2.length() - 6);
                    }
                    if (!bl) {
                        stringBuilder.append('\t');
                    }
                    bl = false;
                    stringBuilder.append('\t').append(string2).append('\n');
                }
            } else if (string.startsWith("Cookies retrieved: {")) {
                String string3 = string.substring(20);
                stringBuilder.append("Cookies from handler:\n");
                while (string3.length() >= 7) {
                    String string4;
                    int n;
                    int n3;
                    Matcher matcher;
                    int n4;
                    String string5;
                    if (string3.startsWith("Cookie=[")) {
                        string5 = string3.substring(8);
                        n4 = string5.indexOf("Cookie2=[");
                        if (n4 > 0) {
                            string5 = string5.substring(0, n4 - 1);
                            string3 = string5.substring(n4);
                        } else {
                            string3 = "";
                        }
                        if (string5.length() < 4) continue;
                        matcher = COOKIE_PATTERN.matcher(string5);
                        while (matcher.find()) {
                            n3 = matcher.start();
                            n = matcher.end();
                            if (n3 < 0) continue;
                            string4 = string5.substring(n3 + 1, n > 0 ? n - 1 : string5.length() - 1);
                            stringBuilder.append("\t").append(string4).append("\n");
                        }
                    }
                    if (!string3.startsWith("Cookie2=[")) continue;
                    string5 = string3.substring(9);
                    n4 = string5.indexOf("Cookie=[");
                    if (n4 > 0) {
                        string5 = string5.substring(0, n4 - 1);
                        string3 = string5.substring(n4);
                    } else {
                        string3 = "";
                    }
                    matcher = COOKIE_PATTERN.matcher(string5);
                    while (matcher.find()) {
                        n3 = matcher.start();
                        n = matcher.end();
                        if (n3 < 0) continue;
                        string4 = string5.substring(n3 + 1, n > 0 ? n - 1 : string5.length() - 1);
                        stringBuilder.append('\t').append(string4).append('\n');
                    }
                }
            } else {
                stringBuilder.append(string);
            }
            if (stringBuilder.charAt(stringBuilder.length() - 1) == '\n') {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

