/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.commons.util;

import io.gatling.commons.util.ReusableGzipOutputStream$;
import io.gatling.commons.util.SettableOutputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import scala.Array$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055q!B\u0001\u0003\u0011\u0003Y\u0011\u0001\u0007*fkN\f'\r\\3Hu&\u0004x*\u001e;qkR\u001cFO]3b[*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u000591m\\7n_:\u001c(BA\u0004\t\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!C\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qB\u0001\rSKV\u001c\u0018M\u00197f\u000fjL\u0007oT;uaV$8\u000b\u001e:fC6\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004\u001b\u001b\t\u0007I\u0011B\u000e\u0002\u0013\u001dS\u0018\u000e]'bO&\u001cW#\u0001\u000f\u0011\u0005Ei\u0012B\u0001\u0010\u0013\u0005\rIe\u000e\u001e\u0005\u0007A5\u0001\u000b\u0011\u0002\u000f\u0002\u0015\u001dS\u0018\u000e]'bO&\u001c\u0007\u0005C\u0004#\u001b\t\u0007I\u0011B\u000e\u0002\u0017Q\u0013\u0018-\u001b7feNK'0\u001a\u0005\u0007I5\u0001\u000b\u0011\u0002\u000f\u0002\u0019Q\u0013\u0018-\u001b7feNK'0\u001a\u0011\t\u000f\u0019j!\u0019!C\u0005O\u000591\u000b\u001e:fC6\u001cX#\u0001\u0015\u0011\u0007%r\u0003'D\u0001+\u0015\tYC&\u0001\u0003mC:<'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u00121\u0002\u00165sK\u0006$Gj\\2bYB\u0011A\"\r\u0004\u0005\u001d\t\u0001!g\u0005\u00022gA\u0011A\u0007O\u0007\u0002k)\u0011agN\u0001\u0004u&\u0004(BA\u0002-\u0013\tITG\u0001\u000bEK\u001ad\u0017\r^3s\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\twE\u0012)\u0019!C\u0001y\u0005\u0011qn]\u000b\u0002{A\u0011ABP\u0005\u0003\u007f\t\u0011AcU3ui\u0006\u0014G.Z(viB,Ho\u0015;sK\u0006l\u0007\u0002C!2\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\u0007=\u001c\b\u0005C\u0003\u0018c\u0011\u00051\t\u0006\u00021\t\")1H\u0011a\u0001{!9a)\rb\u0001\n\u00139\u0015aA2sGV\t\u0001\n\u0005\u00025\u0013&\u0011!*\u000e\u0002\u0006\u0007J\u001b5G\r\u0005\u0007\u0019F\u0002\u000b\u0011\u0002%\u0002\t\r\u00148\r\t\u0005\u0006\u001dF\"\teT\u0001\u0006oJLG/\u001a\u000b\u0005!N[V\f\u0005\u0002\u0012#&\u0011!K\u0005\u0002\u0005+:LG\u000fC\u0003U\u001b\u0002\u0007Q+A\u0002ck\u001a\u00042!\u0005,Y\u0013\t9&CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u00123&\u0011!L\u0005\u0002\u0005\u0005f$X\rC\u0003]\u001b\u0002\u0007A$A\u0002pM\u001aDQAX'A\u0002q\t1\u0001\\3o\u0011\u0015\u0001\u0017\u0007\"\u0011b\u0003\u00191\u0017N\\5tQR\t\u0001\u000bC\u0003dc\u0011\u0005\u0011-A\u0006xe&$X\rS3bI\u0016\u0014\b\"B32\t\u00131\u0017\u0001D<sSR,GK]1jY\u0016\u0014Hc\u0001)hQ\")A\u000b\u001aa\u0001+\")\u0011\u000e\u001aa\u00019\u00051qN\u001a4tKRDQa[\u0019\u0005\n1\f\u0001b\u001e:ji\u0016Le\u000e\u001e\u000b\u0005!6|\u0007\u000fC\u0003oU\u0002\u0007A$A\u0001j\u0011\u0015!&\u000e1\u0001V\u0011\u0015I'\u000e1\u0001\u001d\u0011\u0015\u0011\u0018\u0007\"\u0003t\u0003)9(/\u001b;f'\"|'\u000f\u001e\u000b\u0005!R4x\u000fC\u0003vc\u0002\u0007A$A\u0001t\u0011\u0015!\u0016\u000f1\u0001V\u0011\u0015I\u0017\u000f1\u0001\u001d\u0011\u0015I\u0018\u0007\"\u0001b\u0003\u0015\u0011Xm]3u\u0011\u0019YX\u0002)A\u0005Q\u0005A1\u000b\u001e:fC6\u001c\b\u0005C\u0003~\u001b\u0011\u0005a0A\u0005g_J\u001cFO]3b[R\u0011\u0001g \u0005\b\u0003\u0003a\b\u0019AA\u0002\u0003\u0019!\u0018M]4fiB!\u0011QAA\u0005\u001b\t\t9A\u0003\u0002\nY%!\u00111BA\u0004\u00051yU\u000f\u001e9viN#(/Z1n\u0001")
public class ReusableGzipOutputStream
extends DeflaterOutputStream {
    private final SettableOutputStream os;
    private final CRC32 crc;

    public static ReusableGzipOutputStream forStream(OutputStream outputStream) {
        return ReusableGzipOutputStream$.MODULE$.forStream(outputStream);
    }

    public SettableOutputStream os() {
        return this.os;
    }

    private CRC32 crc() {
        return this.crc;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        super.write(buf, off, len);
        this.crc().update(buf, off, len);
    }

    @Override
    public void finish() {
        block2: {
            if (this.def.finished()) break block2;
            this.def.finish();
            while (!this.def.finished()) {
                int len = this.def.deflate(this.buf, 0, this.buf.length);
                if (this.def.finished() && len <= this.buf.length - ReusableGzipOutputStream$.MODULE$.io$gatling$commons$util$ReusableGzipOutputStream$$TrailerSize()) {
                    this.writeTrailer(this.buf, len);
                    this.os().write(this.buf, 0, len += ReusableGzipOutputStream$.MODULE$.io$gatling$commons$util$ReusableGzipOutputStream$$TrailerSize());
                    return;
                }
                if (len <= 0) continue;
                this.out.write(this.buf, 0, len);
            }
            byte[] trailer = (byte[])Array$.MODULE$.ofDim(ReusableGzipOutputStream$.MODULE$.io$gatling$commons$util$ReusableGzipOutputStream$$TrailerSize(), ClassTag$.MODULE$.Byte());
            this.writeTrailer(trailer, 0);
            this.out.write(trailer);
        }
    }

    public void writeHeader() {
        this.os().write(new byte[]{(byte)ReusableGzipOutputStream$.MODULE$.io$gatling$commons$util$ReusableGzipOutputStream$$GzipMagic(), (byte)(ReusableGzipOutputStream$.MODULE$.io$gatling$commons$util$ReusableGzipOutputStream$$GzipMagic() >> 8), (byte)8, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0});
    }

    private void writeTrailer(byte[] buf, int offset) {
        this.writeInt((int)this.crc().getValue(), buf, offset);
        this.writeInt(this.def.getTotalIn(), buf, offset + 4);
    }

    private void writeInt(int i, byte[] buf, int offset) {
        this.writeShort(i & 0xFFFF, buf, offset);
        this.writeShort(i >> 16 & 0xFFFF, buf, offset + 2);
    }

    private void writeShort(int s, byte[] buf, int offset) {
        buf[offset] = (byte)(s & 0xFF);
        buf[offset + 1] = (byte)(s >> 8 & 0xFF);
    }

    public void reset() {
        this.crc().reset();
        this.def.reset();
        this.os().target_$eq(null);
    }

    public ReusableGzipOutputStream(SettableOutputStream os) {
        this.os = os;
        super((OutputStream)os, new Deflater(-1, true));
        this.crc = new CRC32();
    }
}

