/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import io.freefair.gradle.plugins.lombok.tasks.LombokJarTask;
import javax.inject.Inject;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;

@CacheableTask
public abstract class LombokRuntimeJar
extends LombokJarTask {
    @Inject
    protected abstract ExecOperations getExecOperations();

    @Console
    public abstract Property<Boolean> getPrint();

    @Input
    public abstract Property<Boolean> getCreate();

    public LombokRuntimeJar() {
        this.getArchiveAppendix().convention((Object)"runtime");
        this.getPrint().convention((Object)false);
        this.getCreate().convention((Object)true);
    }

    public void copy() {
        this.getExecOperations().javaexec(runtimeJar -> {
            if (this.getLauncher().isPresent()) {
                runtimeJar.setExecutable(((JavaLauncher)this.getLauncher().get()).getExecutablePath().getAsFile().getAbsolutePath());
            }
            runtimeJar.setClasspath((FileCollection)this.getLombokClasspath());
            runtimeJar.getMainClass().set((Object)"lombok.launch.Main");
            runtimeJar.args(new Object[]{"createRuntime"});
            if (((Boolean)this.getPrint().get()).booleanValue()) {
                runtimeJar.args(new Object[]{"--print"});
            }
            if (((Boolean)this.getCreate().get()).booleanValue()) {
                runtimeJar.args(new Object[]{"--create"});
                runtimeJar.args(new Object[]{"--output=" + ((RegularFile)this.getArchiveFile().get()).getAsFile().getAbsolutePath()});
            }
        });
    }
}

