/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.proxy;

import io.fluentlenium.core.hook.FluentHook;
import io.fluentlenium.core.hook.HookChainBuilder;
import io.fluentlenium.core.hook.HookDefinition;
import io.fluentlenium.core.proxy.LocatorHandler;
import io.fluentlenium.core.proxy.ProxyElementListener;
import io.fluentlenium.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public abstract class AbstractLocatorHandler<T>
implements LocatorHandler<T> {
    private static final String DEFAULT_LAZY_ELEMENT_TO_STRING = "Lazy Element";
    private final List<ProxyElementListener> listeners = new ArrayList<ProxyElementListener>();
    protected final ElementLocator locator;
    protected HookChainBuilder hookChainBuilder;
    protected List<HookDefinition<?>> hookDefinitions;
    protected List<FluentHook> hooks;
    protected T proxy;
    protected T result;

    public AbstractLocatorHandler(ElementLocator locator) {
        this.locator = locator;
    }

    @Override
    public boolean addListener(ProxyElementListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ProxyElementListener listener) {
        return this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getLocatorResult() {
        AbstractLocatorHandler abstractLocatorHandler = this;
        synchronized (abstractLocatorHandler) {
            if (this.loaded() && this.isStale()) {
                this.result = null;
            }
            if (!this.loaded()) {
                this.fireProxyElementSearch();
                this.result = this.getLocatorResultImpl();
                this.fireProxyElementFound(this.result);
            }
            return this.result;
        }
    }

    @Override
    public void setHooks(HookChainBuilder hookChainBuilder, List<HookDefinition<?>> hookDefinitions) {
        if (CollectionUtils.isEmpty(hookDefinitions)) {
            this.hookChainBuilder = null;
            this.hookDefinitions = null;
            this.hooks = null;
        } else {
            this.hookChainBuilder = hookChainBuilder;
            this.hookDefinitions = hookDefinitions;
            this.hooks = hookChainBuilder.build(this::getElement, () -> this.locator, () -> this.proxy.toString(), hookDefinitions);
        }
    }

    @Override
    public ElementLocator getLocator() {
        return this.locator;
    }

    @Override
    public ElementLocator getHookLocator() {
        return CollectionUtils.isEmpty(this.hooks) ? this.locator : (ElementLocator)this.hooks.get(this.hooks.size() - 1);
    }

    @Override
    public boolean loaded() {
        return this.result != null;
    }

    @Override
    public boolean present() {
        try {
            this.now();
        }
        catch (NoSuchElementException | StaleElementReferenceException | TimeoutException e) {
            return false;
        }
        return this.loaded() && !this.isStale();
    }

    @Override
    public void reset() {
        this.result = null;
    }

    public void setProxy(T proxy) {
        this.proxy = proxy;
    }

    protected void fireProxyElementSearch() {
        this.listeners.forEach(listener -> listener.proxyElementSearch(this.proxy, this.locator));
    }

    protected void fireProxyElementFound(T result) {
        this.listeners.forEach(listener -> listener.proxyElementFound(this.proxy, this.locator, this.resultToList(result)));
    }

    public abstract T getLocatorResultImpl();

    protected abstract List<WebElement> resultToList(T var1);

    protected abstract boolean isStale();

    protected abstract WebElement getElement();

    protected String getLazyToString() {
        return DEFAULT_LAZY_ELEMENT_TO_STRING;
    }

    public String proxyToString(String elementToString) {
        if (elementToString == null) {
            elementToString = this.getLazyToString();
        }
        return this.locator instanceof WrapsElement ? elementToString : String.valueOf(this.locator) + " (" + elementToString + ")";
    }
}

