/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.filter;

import io.fluentlenium.core.domain.FluentWebElement;
import io.fluentlenium.core.filter.AttributeFilter;
import java.util.function.Predicate;

public class AttributeFilterPredicate
implements Predicate<FluentWebElement> {
    private final AttributeFilter filter;

    AttributeFilterPredicate(AttributeFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean test(FluentWebElement element) {
        String attribute = this.getAttributeValue(element);
        return this.filter.getMatcher().isSatisfiedBy(attribute);
    }

    private String getAttributeValue(FluentWebElement element) {
        return "text".equalsIgnoreCase(this.filter.getAttribute()) ? element.text() : element.attribute(this.filter.getAttribute());
    }
}

