/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.components;

import io.fluentlenium.core.components.ComponentInstantiator;
import io.fluentlenium.core.components.LazyComponents;
import io.fluentlenium.core.components.LazyComponentsListener;
import io.fluentlenium.core.domain.ListImpl;
import io.fluentlenium.core.domain.WrapsElements;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.openqa.selenium.WebElement;

public class LazyComponentList<T>
extends ListImpl<T>
implements List<T>,
WrapsElements,
LazyComponents<T> {
    private final ComponentInstantiator instantiator;
    private final Class<T> componentClass;
    private final List<WebElement> elements;
    private final List<LazyComponentsListener<T>> lazyComponentsListeners = new ArrayList<LazyComponentsListener<T>>();
    private final AtomicReference<Object> list = new AtomicReference();

    public LazyComponentList(ComponentInstantiator instantiator, Class<T> componentClass, List<WebElement> elements) {
        this.componentClass = componentClass;
        this.instantiator = instantiator;
        this.elements = elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getList() {
        Object value = this.list.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.list;
            synchronized (atomicReference) {
                value = this.list.get();
                if (value == null) {
                    List<T> actualValue = this.transformList();
                    value = actualValue == null ? this.list : actualValue;
                    this.list.set(value);
                }
            }
        }
        return (List)(value == this.list ? null : value);
    }

    protected List<T> transformList() {
        ArrayList<T> components = new ArrayList<T>();
        LinkedHashMap<WebElement, T> componentMap = new LinkedHashMap<WebElement, T>();
        for (WebElement element : this.elements) {
            T component = this.instantiator.newComponent(this.componentClass, element);
            components.add(component);
            componentMap.put(element, component);
        }
        this.fireLazyComponentsInitialized(componentMap);
        return components;
    }

    protected void fireLazyComponentsInitialized(Map<WebElement, T> componentMap) {
        for (LazyComponentsListener<T> listener : this.lazyComponentsListeners) {
            listener.lazyComponentsInitialized(componentMap);
        }
    }

    @Override
    public boolean addLazyComponentsListener(LazyComponentsListener<T> listener) {
        return this.lazyComponentsListeners.add(listener);
    }

    @Override
    public boolean removeLazyComponentsListener(LazyComponentsListener<T> listener) {
        return this.lazyComponentsListeners.remove(listener);
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    @Override
    public boolean isLazyInitialized() {
        return this.list == null;
    }

    @Override
    public List<WebElement> getWrappedElements() {
        return this.elements;
    }

    public String toString() {
        return this.isLazyInitialized() ? this.getList().toString() : this.elements.toString();
    }
}

