/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.configuration;

import io.fluentlenium.configuration.AbstractFactoryRegistryImpl;
import io.fluentlenium.configuration.ConfigurationException;
import io.fluentlenium.configuration.ConfigurationProperties;
import io.fluentlenium.configuration.ReflectiveWebDriverFactory;
import io.fluentlenium.configuration.WebDriverFactory;
import java.util.List;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;

public class WebDriversRegistryImpl
extends AbstractFactoryRegistryImpl<WebDriverFactory, ReflectiveWebDriverFactory> {
    public WebDriversRegistryImpl() {
        super(WebDriverFactory.class, ReflectiveWebDriverFactory.class);
    }

    @Override
    protected ReflectiveWebDriverFactory newReflectiveInstance(String name) {
        return new ReflectiveWebDriverFactory(name, name, new Object[0]);
    }

    @Override
    protected WebDriverFactory getDefault(List<WebDriverFactory> filteredFactories) {
        if (filteredFactories.isEmpty()) {
            throw new ConfigurationException("No WebDriverFactory is available. You need add least one supported WebDriver in your classpath.");
        }
        return filteredFactories.get(0);
    }

    @Override
    protected void handleNoFactoryAvailable(String name) {
        throw new ConfigurationException("No factory is available with this name: " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver newWebDriver(String name, Capabilities capabilities, ConfigurationProperties configuration) {
        WebDriversRegistryImpl webDriversRegistryImpl = this;
        synchronized (webDriversRegistryImpl) {
            return ((WebDriverFactory)this.get(name)).newWebDriver(capabilities, configuration);
        }
    }
}

