/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.configuration;

import io.fluentlenium.configuration.AnnotationConfiguration;
import io.fluentlenium.configuration.ComposedConfiguration;
import io.fluentlenium.configuration.Configuration;
import io.fluentlenium.configuration.ConfigurationDefaults;
import io.fluentlenium.configuration.ConfigurationException;
import io.fluentlenium.configuration.ConfigurationFactory;
import io.fluentlenium.configuration.ConfigurationProperties;
import io.fluentlenium.configuration.DefaultPropertiesBackend;
import io.fluentlenium.configuration.EnvironmentVariablesBackend;
import io.fluentlenium.configuration.ProgrammaticConfiguration;
import io.fluentlenium.configuration.PropertiesBackendConfiguration;
import io.fluentlenium.configuration.SystemPropertiesBackend;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DefaultConfigurationFactory
implements ConfigurationFactory {
    protected InputStream getPropertiesInputStream() {
        return this.getClass().getResourceAsStream("/fluentlenium.properties");
    }

    @Override
    public Configuration newConfiguration(Class<?> containerClass, ConfigurationProperties configurationDefaults) {
        InputStream configurationFile;
        Properties properties = new Properties();
        if (configurationDefaults == null) {
            configurationDefaults = new ConfigurationDefaults();
        }
        if ((configurationFile = this.getPropertiesInputStream()) != null) {
            try {
                properties.load(configurationFile);
            }
            catch (IOException e) {
                throw new ConfigurationException("Can't read fluentlenium.properties. " + String.valueOf(e));
            }
        }
        ProgrammaticConfiguration programmaticConfiguration = new ProgrammaticConfiguration();
        ComposedConfiguration configuration = new ComposedConfiguration(programmaticConfiguration, programmaticConfiguration, new PropertiesBackendConfiguration(new SystemPropertiesBackend()), new PropertiesBackendConfiguration(new EnvironmentVariablesBackend()), new AnnotationConfiguration(containerClass), new PropertiesBackendConfiguration(new DefaultPropertiesBackend(properties), "", "fluentlenium."), configurationDefaults);
        return configuration;
    }
}

