/*
 * Decompiled with CFR 0.152.
 */
package io.fares.bind.xjc.plugins.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.xml.xsom.XSAttributeUse;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;

public class FixedAttributeValueProcessor {
    void process(ClassOutline classOutline) {
        JDefinedClass implClass = classOutline.getImplClass();
        for (FieldOutline field : classOutline.getDeclaredFields()) {
            JFieldVar jField = this.findFixedField(implClass, field);
            if (jField == null) continue;
            CAttributePropertyInfo propertyInfo = (CAttributePropertyInfo)field.getPropertyInfo();
            QName xmlName = propertyInfo.getXmlName();
            String attrName = xmlName.getLocalPart();
            String cap = attrName.substring(0, 1).toUpperCase() + attrName.substring(1);
            JMethod method = implClass.method(1, jField.type(), "get" + cap);
            method.body()._return((JExpression)JExpr.ref((String)jField.name()));
            method.annotate(XmlTransient.class);
            JAnnotationUse jsonPropertyUse = method.annotate(JsonProperty.class);
            jsonPropertyUse.param("access", (Enum)JsonProperty.Access.READ_ONLY);
        }
    }

    private JFieldVar findFixedField(JDefinedClass implClass, FieldOutline field) {
        if (field.getPropertyInfo() instanceof CAttributePropertyInfo && field.getPropertyInfo().getSchemaComponent() instanceof XSAttributeUse) {
            XSAttributeUse attributeUse = (XSAttributeUse)field.getPropertyInfo().getSchemaComponent();
            JFieldVar jField = (JFieldVar)implClass.fields().get(field.getPropertyInfo().getName(true));
            if (attributeUse.getFixedValue() != null && jField != null && jField.mods().getValue() == 25) {
                return jField;
            }
        }
        return null;
    }
}

