/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.servicecatalog.api.model.ServicePlan;
import io.fabric8.servicecatalog.api.model.ServicePlanFluent;
import io.fabric8.servicecatalog.api.model.ServicePlanSpec;
import io.fabric8.servicecatalog.api.model.ServicePlanSpecBuilder;
import io.fabric8.servicecatalog.api.model.ServicePlanSpecFluentImpl;
import io.fabric8.servicecatalog.api.model.ServicePlanStatus;
import io.fabric8.servicecatalog.api.model.ServicePlanStatusBuilder;
import io.fabric8.servicecatalog.api.model.ServicePlanStatusFluentImpl;
import java.util.Objects;

public class ServicePlanFluentImpl<A extends ServicePlanFluent<A>>
extends BaseFluent<A>
implements ServicePlanFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ServicePlanSpecBuilder spec;
    private ServicePlanStatusBuilder status;

    public ServicePlanFluentImpl() {
    }

    public ServicePlanFluentImpl(ServicePlan instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ServicePlanFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ServicePlanFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ServicePlanFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ServicePlanFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ServicePlanFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ServicePlanSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ServicePlanSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ServicePlanSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ServicePlanSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ServicePlanFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ServicePlanFluent.SpecNested<A> withNewSpecLike(ServicePlanSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ServicePlanFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ServicePlanFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ServicePlanSpecBuilder().build());
    }

    @Override
    public ServicePlanFluent.SpecNested<A> editOrNewSpecLike(ServicePlanSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ServicePlanStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ServicePlanStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ServicePlanStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new ServicePlanStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public A withNewStatus(Boolean removedFromBrokerCatalog) {
        return this.withStatus(new ServicePlanStatus(removedFromBrokerCatalog));
    }

    @Override
    public ServicePlanFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ServicePlanFluent.StatusNested<A> withNewStatusLike(ServicePlanStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ServicePlanFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ServicePlanFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ServicePlanStatusBuilder().build());
    }

    @Override
    public ServicePlanFluent.StatusNested<A> editOrNewStatusLike(ServicePlanStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServicePlanFluentImpl that = (ServicePlanFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends ServicePlanStatusFluentImpl<ServicePlanFluent.StatusNested<N>>
    implements ServicePlanFluent.StatusNested<N>,
    Nested<N> {
        ServicePlanStatusBuilder builder;

        StatusNestedImpl(ServicePlanStatus item) {
            this.builder = new ServicePlanStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ServicePlanStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServicePlanFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends ServicePlanSpecFluentImpl<ServicePlanFluent.SpecNested<N>>
    implements ServicePlanFluent.SpecNested<N>,
    Nested<N> {
        ServicePlanSpecBuilder builder;

        SpecNestedImpl(ServicePlanSpec item) {
            this.builder = new ServicePlanSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ServicePlanSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServicePlanFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ServicePlanFluent.MetadataNested<N>>
    implements ServicePlanFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ServicePlanFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

