/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.ClusterNetworkEntryFluent;
import io.fabric8.openshift.api.model.ClusterNetworkEntryFluentImpl;

public class ClusterNetworkEntryBuilder
extends ClusterNetworkEntryFluentImpl<ClusterNetworkEntryBuilder>
implements VisitableBuilder<ClusterNetworkEntry, ClusterNetworkEntryBuilder> {
    ClusterNetworkEntryFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterNetworkEntryBuilder() {
        this(false);
    }

    public ClusterNetworkEntryBuilder(Boolean validationEnabled) {
        this(new ClusterNetworkEntry(), validationEnabled);
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterNetworkEntry(), validationEnabled);
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent, ClusterNetworkEntry instance) {
        this(fluent, instance, false);
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent, ClusterNetworkEntry instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withCidr(instance.getCidr());
            fluent.withHostSubnetLength(instance.getHostSubnetLength());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntry instance) {
        this(instance, (Boolean)false);
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntry instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withCidr(instance.getCidr());
            this.withHostSubnetLength(instance.getHostSubnetLength());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ClusterNetworkEntry build() {
        ClusterNetworkEntry buildable = new ClusterNetworkEntry(this.fluent.getCidr(), this.fluent.getHostSubnetLength());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

