package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface TemplateInstanceListFluent<A extends TemplateInstanceListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,TemplateInstance item);
  public A setToItems(int index,TemplateInstance item);
  public A addToItems(io.fabric8.openshift.api.model.TemplateInstance... items);
  public A addAllToItems(Collection<TemplateInstance> items);
  public A removeFromItems(io.fabric8.openshift.api.model.TemplateInstance... items);
  public A removeAllFromItems(Collection<TemplateInstance> items);
  public A removeMatchingFromItems(Predicate<TemplateInstanceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TemplateInstance> getItems();
  public List<TemplateInstance> buildItems();
  public TemplateInstance buildItem(int index);
  public TemplateInstance buildFirstItem();
  public TemplateInstance buildLastItem();
  public TemplateInstance buildMatchingItem(Predicate<TemplateInstanceBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<TemplateInstanceBuilder> predicate);
  public A withItems(List<TemplateInstance> items);
  public A withItems(io.fabric8.openshift.api.model.TemplateInstance... items);
  public Boolean hasItems();
  public TemplateInstanceListFluent.ItemsNested<A> addNewItem();
  public TemplateInstanceListFluent.ItemsNested<A> addNewItemLike(TemplateInstance item);
  public TemplateInstanceListFluent.ItemsNested<A> setNewItemLike(int index,TemplateInstance item);
  public TemplateInstanceListFluent.ItemsNested<A> editItem(int index);
  public TemplateInstanceListFluent.ItemsNested<A> editFirstItem();
  public TemplateInstanceListFluent.ItemsNested<A> editLastItem();
  public TemplateInstanceListFluent.ItemsNested<A> editMatchingItem(Predicate<TemplateInstanceBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,TemplateInstanceFluent<TemplateInstanceListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}