package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SignatureConditionBuilder extends SignatureConditionFluentImpl<SignatureConditionBuilder> implements VisitableBuilder<SignatureCondition,SignatureConditionBuilder>{
  public SignatureConditionBuilder() {
    this(false);
  }
  public SignatureConditionBuilder(Boolean validationEnabled) {
    this(new SignatureCondition(), validationEnabled);
  }
  public SignatureConditionBuilder(SignatureConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public SignatureConditionBuilder(SignatureConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SignatureCondition(), validationEnabled);
  }
  public SignatureConditionBuilder(SignatureConditionFluent<?> fluent,SignatureCondition instance) {
    this(fluent, instance, false);
  }
  public SignatureConditionBuilder(SignatureConditionFluent<?> fluent,SignatureCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastProbeTime(instance.getLastProbeTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SignatureConditionBuilder(SignatureCondition instance) {
    this(instance,false);
  }
  public SignatureConditionBuilder(SignatureCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastProbeTime(instance.getLastProbeTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SignatureConditionFluent<?> fluent;
  Boolean validationEnabled;
  public SignatureCondition build() {
    SignatureCondition buildable = new SignatureCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}