package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ScopeRestrictionFluentImpl<A extends ScopeRestrictionFluent<A>> extends BaseFluent<A> implements ScopeRestrictionFluent<A>{
  public ScopeRestrictionFluentImpl() {
  }
  public ScopeRestrictionFluentImpl(ScopeRestriction instance) {
    if (instance != null) {
      this.withClusterRole(instance.getClusterRole());
      this.withLiterals(instance.getLiterals());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ClusterRoleScopeRestrictionBuilder clusterRole;
  private List<String> literals = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildClusterRole instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterRoleScopeRestriction getClusterRole() {
    return this.clusterRole!=null ?this.clusterRole.build():null;
  }
  public ClusterRoleScopeRestriction buildClusterRole() {
    return this.clusterRole!=null ?this.clusterRole.build():null;
  }
  public A withClusterRole(ClusterRoleScopeRestriction clusterRole) {
    _visitables.get("clusterRole").remove(this.clusterRole);
    if (clusterRole!=null){ this.clusterRole= new ClusterRoleScopeRestrictionBuilder(clusterRole); _visitables.get("clusterRole").add(this.clusterRole);} else { this.clusterRole = null; _visitables.get("clusterRole").remove(this.clusterRole); } return (A) this;
  }
  public Boolean hasClusterRole() {
    return this.clusterRole != null;
  }
  public ScopeRestrictionFluentImpl.ClusterRoleNested<A> withNewClusterRole() {
    return new ScopeRestrictionFluentImpl.ClusterRoleNestedImpl();
  }
  public ScopeRestrictionFluentImpl.ClusterRoleNested<A> withNewClusterRoleLike(ClusterRoleScopeRestriction item) {
    return new ScopeRestrictionFluentImpl.ClusterRoleNestedImpl(item);
  }
  public ScopeRestrictionFluentImpl.ClusterRoleNested<A> editClusterRole() {
    return withNewClusterRoleLike(getClusterRole());
  }
  public ScopeRestrictionFluentImpl.ClusterRoleNested<A> editOrNewClusterRole() {
    return withNewClusterRoleLike(getClusterRole() != null ? getClusterRole(): new ClusterRoleScopeRestrictionBuilder().build());
  }
  public ScopeRestrictionFluentImpl.ClusterRoleNested<A> editOrNewClusterRoleLike(ClusterRoleScopeRestriction item) {
    return withNewClusterRoleLike(getClusterRole() != null ? getClusterRole(): item);
  }
  public A addToLiterals(int index,String item) {
    if (this.literals == null) {this.literals = new ArrayList<String>();}
    this.literals.add(index, item);
    return (A)this;
  }
  public A setToLiterals(int index,String item) {
    if (this.literals == null) {this.literals = new ArrayList<String>();}
    this.literals.set(index, item); return (A)this;
  }
  public A addToLiterals(java.lang.String... items) {
    if (this.literals == null) {this.literals = new ArrayList<String>();}
    for (String item : items) {this.literals.add(item);} return (A)this;
  }
  public A addAllToLiterals(Collection<String> items) {
    if (this.literals == null) {this.literals = new ArrayList<String>();}
    for (String item : items) {this.literals.add(item);} return (A)this;
  }
  public A removeFromLiterals(java.lang.String... items) {
    for (String item : items) {if (this.literals!= null){ this.literals.remove(item);}} return (A)this;
  }
  public A removeAllFromLiterals(Collection<String> items) {
    for (String item : items) {if (this.literals!= null){ this.literals.remove(item);}} return (A)this;
  }
  public List<String> getLiterals() {
    return this.literals;
  }
  public String getLiteral(int index) {
    return this.literals.get(index);
  }
  public String getFirstLiteral() {
    return this.literals.get(0);
  }
  public String getLastLiteral() {
    return this.literals.get(literals.size() - 1);
  }
  public String getMatchingLiteral(Predicate<String> predicate) {
    for (String item: literals) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingLiteral(Predicate<String> predicate) {
    for (String item: literals) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLiterals(List<String> literals) {
    if (literals != null) {this.literals = new ArrayList(); for (String item : literals){this.addToLiterals(item);}} else { this.literals = null;} return (A) this;
  }
  public A withLiterals(java.lang.String... literals) {
    if (this.literals != null) {this.literals.clear(); _visitables.remove("literals"); }
    if (literals != null) {for (String item :literals){ this.addToLiterals(item);}} return (A) this;
  }
  public Boolean hasLiterals() {
    return literals != null && !literals.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ScopeRestrictionFluentImpl that = (ScopeRestrictionFluentImpl) o;
    if (!java.util.Objects.equals(clusterRole, that.clusterRole)) return false;

    if (!java.util.Objects.equals(literals, that.literals)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterRole,  literals,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterRole != null) { sb.append("clusterRole:"); sb.append(clusterRole + ","); }
    if (literals != null && !literals.isEmpty()) { sb.append("literals:"); sb.append(literals + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClusterRoleNestedImpl<N> extends ClusterRoleScopeRestrictionFluentImpl<ScopeRestrictionFluentImpl.ClusterRoleNested<N>> implements ScopeRestrictionFluentImpl.ClusterRoleNested<N>,Nested<N>{
    ClusterRoleNestedImpl(ClusterRoleScopeRestriction item) {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this, item);
    }
    ClusterRoleNestedImpl() {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this);
    }
    ClusterRoleScopeRestrictionBuilder builder;
    public N and() {
      return (N) ScopeRestrictionFluentImpl.this.withClusterRole(builder.build());
    }
    public N endClusterRole() {
      return and();
    }
    
  }
  
}