package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScopeRestrictionBuilder extends ScopeRestrictionFluentImpl<ScopeRestrictionBuilder> implements VisitableBuilder<ScopeRestriction,ScopeRestrictionBuilder>{
  public ScopeRestrictionBuilder() {
    this(false);
  }
  public ScopeRestrictionBuilder(Boolean validationEnabled) {
    this(new ScopeRestriction(), validationEnabled);
  }
  public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent) {
    this(fluent, false);
  }
  public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ScopeRestriction(), validationEnabled);
  }
  public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent,ScopeRestriction instance) {
    this(fluent, instance, false);
  }
  public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent,ScopeRestriction instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClusterRole(instance.getClusterRole());
      fluent.withLiterals(instance.getLiterals());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ScopeRestrictionBuilder(ScopeRestriction instance) {
    this(instance,false);
  }
  public ScopeRestrictionBuilder(ScopeRestriction instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClusterRole(instance.getClusterRole());
      this.withLiterals(instance.getLiterals());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ScopeRestrictionFluent<?> fluent;
  Boolean validationEnabled;
  public ScopeRestriction build() {
    ScopeRestriction buildable = new ScopeRestriction(fluent.getClusterRole(),fluent.getLiterals());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}