package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface RoleBindingFluent<A extends RoleBindingFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToGroupNames(int index,String item);
  public A setToGroupNames(int index,String item);
  public A addToGroupNames(java.lang.String... items);
  public A addAllToGroupNames(Collection<String> items);
  public A removeFromGroupNames(java.lang.String... items);
  public A removeAllFromGroupNames(Collection<String> items);
  public List<String> getGroupNames();
  public String getGroupName(int index);
  public String getFirstGroupName();
  public String getLastGroupName();
  public String getMatchingGroupName(Predicate<String> predicate);
  public Boolean hasMatchingGroupName(Predicate<String> predicate);
  public A withGroupNames(List<String> groupNames);
  public A withGroupNames(java.lang.String... groupNames);
  public Boolean hasGroupNames();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public RoleBindingFluent.MetadataNested<A> withNewMetadata();
  public RoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public RoleBindingFluent.MetadataNested<A> editMetadata();
  public RoleBindingFluent.MetadataNested<A> editOrNewMetadata();
  public RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildRoleRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getRoleRef();
  public ObjectReference buildRoleRef();
  public A withRoleRef(ObjectReference roleRef);
  public Boolean hasRoleRef();
  public RoleBindingFluent.RoleRefNested<A> withNewRoleRef();
  public RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(ObjectReference item);
  public RoleBindingFluent.RoleRefNested<A> editRoleRef();
  public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef();
  public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(ObjectReference item);
  public A addToSubjects(int index,ObjectReference item);
  public A setToSubjects(int index,ObjectReference item);
  public A addToSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items);
  public A addAllToSubjects(Collection<ObjectReference> items);
  public A removeFromSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items);
  public A removeAllFromSubjects(Collection<ObjectReference> items);
  public A removeMatchingFromSubjects(Predicate<ObjectReferenceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSubjects instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ObjectReference> getSubjects();
  public List<ObjectReference> buildSubjects();
  public ObjectReference buildSubject(int index);
  public ObjectReference buildFirstSubject();
  public ObjectReference buildLastSubject();
  public ObjectReference buildMatchingSubject(Predicate<ObjectReferenceBuilder> predicate);
  public Boolean hasMatchingSubject(Predicate<ObjectReferenceBuilder> predicate);
  public A withSubjects(List<ObjectReference> subjects);
  public A withSubjects(io.fabric8.kubernetes.api.model.ObjectReference... subjects);
  public Boolean hasSubjects();
  public RoleBindingFluent.SubjectsNested<A> addNewSubject();
  public RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(ObjectReference item);
  public RoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index,ObjectReference item);
  public RoleBindingFluent.SubjectsNested<A> editSubject(int index);
  public RoleBindingFluent.SubjectsNested<A> editFirstSubject();
  public RoleBindingFluent.SubjectsNested<A> editLastSubject();
  public RoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<ObjectReferenceBuilder> predicate);
  public A addToUserNames(int index,String item);
  public A setToUserNames(int index,String item);
  public A addToUserNames(java.lang.String... items);
  public A addAllToUserNames(Collection<String> items);
  public A removeFromUserNames(java.lang.String... items);
  public A removeAllFromUserNames(Collection<String> items);
  public List<String> getUserNames();
  public String getUserName(int index);
  public String getFirstUserName();
  public String getLastUserName();
  public String getMatchingUserName(Predicate<String> predicate);
  public Boolean hasMatchingUserName(Predicate<String> predicate);
  public A withUserNames(List<String> userNames);
  public A withUserNames(java.lang.String... userNames);
  public Boolean hasUserNames();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<RoleBindingFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface RoleRefNested<N> extends Nested<N>,ObjectReferenceFluent<RoleBindingFluent.RoleRefNested<N>>{
    public N and();
    public N endRoleRef();
    
  }
  public interface SubjectsNested<N> extends Nested<N>,ObjectReferenceFluent<RoleBindingFluent.SubjectsNested<N>>{
    public N and();
    public N endSubject();
    
  }
  
}