package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RangeAllocationFluentImpl<A extends RangeAllocationFluent<A>> extends BaseFluent<A> implements RangeAllocationFluent<A>{
  public RangeAllocationFluentImpl() {
  }
  public RangeAllocationFluentImpl(RangeAllocation instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withData(instance.getData());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withRange(instance.getRange());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String data;
  private String kind;
  private ObjectMetaBuilder metadata;
  private String range;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getData() {
    return this.data;
  }
  public A withData(String data) {
    this.data=data; return (A) this;
  }
  public Boolean hasData() {
    return this.data != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public RangeAllocationFluentImpl.MetadataNested<A> withNewMetadata() {
    return new RangeAllocationFluentImpl.MetadataNestedImpl();
  }
  public RangeAllocationFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new RangeAllocationFluentImpl.MetadataNestedImpl(item);
  }
  public RangeAllocationFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public RangeAllocationFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public RangeAllocationFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public String getRange() {
    return this.range;
  }
  public A withRange(String range) {
    this.range=range; return (A) this;
  }
  public Boolean hasRange() {
    return this.range != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RangeAllocationFluentImpl that = (RangeAllocationFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(data, that.data)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(range, that.range)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  data,  kind,  metadata,  range,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (data != null) { sb.append("data:"); sb.append(data + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (range != null) { sb.append("range:"); sb.append(range + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<RangeAllocationFluentImpl.MetadataNested<N>> implements RangeAllocationFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) RangeAllocationFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}