package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RangeAllocationBuilder extends RangeAllocationFluentImpl<RangeAllocationBuilder> implements VisitableBuilder<RangeAllocation,RangeAllocationBuilder>{
  public RangeAllocationBuilder() {
    this(false);
  }
  public RangeAllocationBuilder(Boolean validationEnabled) {
    this(new RangeAllocation(), validationEnabled);
  }
  public RangeAllocationBuilder(RangeAllocationFluent<?> fluent) {
    this(fluent, false);
  }
  public RangeAllocationBuilder(RangeAllocationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RangeAllocation(), validationEnabled);
  }
  public RangeAllocationBuilder(RangeAllocationFluent<?> fluent,RangeAllocation instance) {
    this(fluent, instance, false);
  }
  public RangeAllocationBuilder(RangeAllocationFluent<?> fluent,RangeAllocation instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withData(instance.getData());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withRange(instance.getRange());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RangeAllocationBuilder(RangeAllocation instance) {
    this(instance,false);
  }
  public RangeAllocationBuilder(RangeAllocation instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withData(instance.getData());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withRange(instance.getRange());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RangeAllocationFluent<?> fluent;
  Boolean validationEnabled;
  public RangeAllocation build() {
    RangeAllocation buildable = new RangeAllocation(fluent.getApiVersion(),fluent.getData(),fluent.getKind(),fluent.getMetadata(),fluent.getRange());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}