package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityPolicyReviewStatusBuilder extends PodSecurityPolicyReviewStatusFluentImpl<PodSecurityPolicyReviewStatusBuilder> implements VisitableBuilder<PodSecurityPolicyReviewStatus,PodSecurityPolicyReviewStatusBuilder>{
  public PodSecurityPolicyReviewStatusBuilder() {
    this(false);
  }
  public PodSecurityPolicyReviewStatusBuilder(Boolean validationEnabled) {
    this(new PodSecurityPolicyReviewStatus(), validationEnabled);
  }
  public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSecurityPolicyReviewStatus(), validationEnabled);
  }
  public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatusFluent<?> fluent,PodSecurityPolicyReviewStatus instance) {
    this(fluent, instance, false);
  }
  public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatusFluent<?> fluent,PodSecurityPolicyReviewStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAllowedServiceAccounts(instance.getAllowedServiceAccounts());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatus instance) {
    this(instance,false);
  }
  public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAllowedServiceAccounts(instance.getAllowedServiceAccounts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSecurityPolicyReviewStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodSecurityPolicyReviewStatus build() {
    PodSecurityPolicyReviewStatus buildable = new PodSecurityPolicyReviewStatus(fluent.getAllowedServiceAccounts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}