package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthClientAuthorizationBuilder extends OAuthClientAuthorizationFluentImpl<OAuthClientAuthorizationBuilder> implements VisitableBuilder<OAuthClientAuthorization,OAuthClientAuthorizationBuilder>{
  public OAuthClientAuthorizationBuilder() {
    this(false);
  }
  public OAuthClientAuthorizationBuilder(Boolean validationEnabled) {
    this(new OAuthClientAuthorization(), validationEnabled);
  }
  public OAuthClientAuthorizationBuilder(OAuthClientAuthorizationFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthClientAuthorizationBuilder(OAuthClientAuthorizationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuthClientAuthorization(), validationEnabled);
  }
  public OAuthClientAuthorizationBuilder(OAuthClientAuthorizationFluent<?> fluent,OAuthClientAuthorization instance) {
    this(fluent, instance, false);
  }
  public OAuthClientAuthorizationBuilder(OAuthClientAuthorizationFluent<?> fluent,OAuthClientAuthorization instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withClientName(instance.getClientName());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withScopes(instance.getScopes());
      fluent.withUserName(instance.getUserName());
      fluent.withUserUID(instance.getUserUID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OAuthClientAuthorizationBuilder(OAuthClientAuthorization instance) {
    this(instance,false);
  }
  public OAuthClientAuthorizationBuilder(OAuthClientAuthorization instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withClientName(instance.getClientName());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withScopes(instance.getScopes());
      this.withUserName(instance.getUserName());
      this.withUserUID(instance.getUserUID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OAuthClientAuthorizationFluent<?> fluent;
  Boolean validationEnabled;
  public OAuthClientAuthorization build() {
    OAuthClientAuthorization buildable = new OAuthClientAuthorization(fluent.getApiVersion(),fluent.getClientName(),fluent.getKind(),fluent.getMetadata(),fluent.getScopes(),fluent.getUserName(),fluent.getUserUID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}