package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JenkinsPipelineBuildStrategyBuilder extends JenkinsPipelineBuildStrategyFluentImpl<JenkinsPipelineBuildStrategyBuilder> implements VisitableBuilder<JenkinsPipelineBuildStrategy,JenkinsPipelineBuildStrategyBuilder>{
  public JenkinsPipelineBuildStrategyBuilder() {
    this(false);
  }
  public JenkinsPipelineBuildStrategyBuilder(Boolean validationEnabled) {
    this(new JenkinsPipelineBuildStrategy(), validationEnabled);
  }
  public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JenkinsPipelineBuildStrategy(), validationEnabled);
  }
  public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategyFluent<?> fluent,JenkinsPipelineBuildStrategy instance) {
    this(fluent, instance, false);
  }
  public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategyFluent<?> fluent,JenkinsPipelineBuildStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEnv(instance.getEnv());
      fluent.withJenkinsfile(instance.getJenkinsfile());
      fluent.withJenkinsfilePath(instance.getJenkinsfilePath());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategy instance) {
    this(instance,false);
  }
  public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEnv(instance.getEnv());
      this.withJenkinsfile(instance.getJenkinsfile());
      this.withJenkinsfilePath(instance.getJenkinsfilePath());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  JenkinsPipelineBuildStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public JenkinsPipelineBuildStrategy build() {
    JenkinsPipelineBuildStrategy buildable = new JenkinsPipelineBuildStrategy(fluent.getEnv(),fluent.getJenkinsfile(),fluent.getJenkinsfilePath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}