package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageStreamMappingFluentImpl<A extends ImageStreamMappingFluent<A>> extends BaseFluent<A> implements ImageStreamMappingFluent<A>{
  public ImageStreamMappingFluentImpl() {
  }
  public ImageStreamMappingFluentImpl(ImageStreamMapping instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withImage(instance.getImage());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withTag(instance.getTag());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private ImageBuilder image;
  private String kind;
  private ObjectMetaBuilder metadata;
  private String tag;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildImage instead.
   * @return The buildable object.
   */
  @Deprecated
  public Image getImage() {
    return this.image!=null ?this.image.build():null;
  }
  public Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  public A withImage(Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new ImageBuilder(image); _visitables.get("image").add(this.image);} else { this.image = null; _visitables.get("image").remove(this.image); } return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public ImageStreamMappingFluentImpl.ImageNested<A> withNewImage() {
    return new ImageStreamMappingFluentImpl.ImageNestedImpl();
  }
  public ImageStreamMappingFluentImpl.ImageNested<A> withNewImageLike(Image item) {
    return new ImageStreamMappingFluentImpl.ImageNestedImpl(item);
  }
  public ImageStreamMappingFluentImpl.ImageNested<A> editImage() {
    return withNewImageLike(getImage());
  }
  public ImageStreamMappingFluentImpl.ImageNested<A> editOrNewImage() {
    return withNewImageLike(getImage() != null ? getImage(): new ImageBuilder().build());
  }
  public ImageStreamMappingFluentImpl.ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(getImage() != null ? getImage(): item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ImageStreamMappingFluentImpl.MetadataNested<A> withNewMetadata() {
    return new ImageStreamMappingFluentImpl.MetadataNestedImpl();
  }
  public ImageStreamMappingFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ImageStreamMappingFluentImpl.MetadataNestedImpl(item);
  }
  public ImageStreamMappingFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ImageStreamMappingFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ImageStreamMappingFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public String getTag() {
    return this.tag;
  }
  public A withTag(String tag) {
    this.tag=tag; return (A) this;
  }
  public Boolean hasTag() {
    return this.tag != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageStreamMappingFluentImpl that = (ImageStreamMappingFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(tag, that.tag)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  image,  kind,  metadata,  tag,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (tag != null) { sb.append("tag:"); sb.append(tag + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImageNestedImpl<N> extends ImageFluentImpl<ImageStreamMappingFluentImpl.ImageNested<N>> implements ImageStreamMappingFluentImpl.ImageNested<N>,Nested<N>{
    ImageNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) ImageStreamMappingFluentImpl.this.withImage(builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ImageStreamMappingFluentImpl.MetadataNested<N>> implements ImageStreamMappingFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ImageStreamMappingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}