package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamImageBuilder extends ImageStreamImageFluentImpl<ImageStreamImageBuilder> implements VisitableBuilder<ImageStreamImage,ImageStreamImageBuilder>{
  public ImageStreamImageBuilder() {
    this(false);
  }
  public ImageStreamImageBuilder(Boolean validationEnabled) {
    this(new ImageStreamImage(), validationEnabled);
  }
  public ImageStreamImageBuilder(ImageStreamImageFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamImageBuilder(ImageStreamImageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStreamImage(), validationEnabled);
  }
  public ImageStreamImageBuilder(ImageStreamImageFluent<?> fluent,ImageStreamImage instance) {
    this(fluent, instance, false);
  }
  public ImageStreamImageBuilder(ImageStreamImageFluent<?> fluent,ImageStreamImage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withImage(instance.getImage());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamImageBuilder(ImageStreamImage instance) {
    this(instance,false);
  }
  public ImageStreamImageBuilder(ImageStreamImage instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withImage(instance.getImage());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageStreamImageFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStreamImage build() {
    ImageStreamImage buildable = new ImageStreamImage(fluent.getApiVersion(),fluent.getImage(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}