package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HostSubnetFluentImpl<A extends HostSubnetFluent<A>> extends BaseFluent<A> implements HostSubnetFluent<A>{
  public HostSubnetFluentImpl() {
  }
  public HostSubnetFluentImpl(HostSubnet instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withEgressCIDRs(instance.getEgressCIDRs());
      this.withEgressIPs(instance.getEgressIPs());
      this.withHost(instance.getHost());
      this.withHostIP(instance.getHostIP());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSubnet(instance.getSubnet());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private List<String> egressCIDRs = new ArrayList<String>();
  private List<String> egressIPs = new ArrayList<String>();
  private String host;
  private String hostIP;
  private String kind;
  private ObjectMetaBuilder metadata;
  private String subnet;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToEgressCIDRs(int index,String item) {
    if (this.egressCIDRs == null) {this.egressCIDRs = new ArrayList<String>();}
    this.egressCIDRs.add(index, item);
    return (A)this;
  }
  public A setToEgressCIDRs(int index,String item) {
    if (this.egressCIDRs == null) {this.egressCIDRs = new ArrayList<String>();}
    this.egressCIDRs.set(index, item); return (A)this;
  }
  public A addToEgressCIDRs(java.lang.String... items) {
    if (this.egressCIDRs == null) {this.egressCIDRs = new ArrayList<String>();}
    for (String item : items) {this.egressCIDRs.add(item);} return (A)this;
  }
  public A addAllToEgressCIDRs(Collection<String> items) {
    if (this.egressCIDRs == null) {this.egressCIDRs = new ArrayList<String>();}
    for (String item : items) {this.egressCIDRs.add(item);} return (A)this;
  }
  public A removeFromEgressCIDRs(java.lang.String... items) {
    for (String item : items) {if (this.egressCIDRs!= null){ this.egressCIDRs.remove(item);}} return (A)this;
  }
  public A removeAllFromEgressCIDRs(Collection<String> items) {
    for (String item : items) {if (this.egressCIDRs!= null){ this.egressCIDRs.remove(item);}} return (A)this;
  }
  public List<String> getEgressCIDRs() {
    return this.egressCIDRs;
  }
  public String getEgressCIDR(int index) {
    return this.egressCIDRs.get(index);
  }
  public String getFirstEgressCIDR() {
    return this.egressCIDRs.get(0);
  }
  public String getLastEgressCIDR() {
    return this.egressCIDRs.get(egressCIDRs.size() - 1);
  }
  public String getMatchingEgressCIDR(Predicate<String> predicate) {
    for (String item: egressCIDRs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEgressCIDR(Predicate<String> predicate) {
    for (String item: egressCIDRs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEgressCIDRs(List<String> egressCIDRs) {
    if (egressCIDRs != null) {this.egressCIDRs = new ArrayList(); for (String item : egressCIDRs){this.addToEgressCIDRs(item);}} else { this.egressCIDRs = null;} return (A) this;
  }
  public A withEgressCIDRs(java.lang.String... egressCIDRs) {
    if (this.egressCIDRs != null) {this.egressCIDRs.clear(); _visitables.remove("egressCIDRs"); }
    if (egressCIDRs != null) {for (String item :egressCIDRs){ this.addToEgressCIDRs(item);}} return (A) this;
  }
  public Boolean hasEgressCIDRs() {
    return egressCIDRs != null && !egressCIDRs.isEmpty();
  }
  public A addToEgressIPs(int index,String item) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    this.egressIPs.add(index, item);
    return (A)this;
  }
  public A setToEgressIPs(int index,String item) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    this.egressIPs.set(index, item); return (A)this;
  }
  public A addToEgressIPs(java.lang.String... items) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    for (String item : items) {this.egressIPs.add(item);} return (A)this;
  }
  public A addAllToEgressIPs(Collection<String> items) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    for (String item : items) {this.egressIPs.add(item);} return (A)this;
  }
  public A removeFromEgressIPs(java.lang.String... items) {
    for (String item : items) {if (this.egressIPs!= null){ this.egressIPs.remove(item);}} return (A)this;
  }
  public A removeAllFromEgressIPs(Collection<String> items) {
    for (String item : items) {if (this.egressIPs!= null){ this.egressIPs.remove(item);}} return (A)this;
  }
  public List<String> getEgressIPs() {
    return this.egressIPs;
  }
  public String getEgressIP(int index) {
    return this.egressIPs.get(index);
  }
  public String getFirstEgressIP() {
    return this.egressIPs.get(0);
  }
  public String getLastEgressIP() {
    return this.egressIPs.get(egressIPs.size() - 1);
  }
  public String getMatchingEgressIP(Predicate<String> predicate) {
    for (String item: egressIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEgressIP(Predicate<String> predicate) {
    for (String item: egressIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEgressIPs(List<String> egressIPs) {
    if (egressIPs != null) {this.egressIPs = new ArrayList(); for (String item : egressIPs){this.addToEgressIPs(item);}} else { this.egressIPs = null;} return (A) this;
  }
  public A withEgressIPs(java.lang.String... egressIPs) {
    if (this.egressIPs != null) {this.egressIPs.clear(); _visitables.remove("egressIPs"); }
    if (egressIPs != null) {for (String item :egressIPs){ this.addToEgressIPs(item);}} return (A) this;
  }
  public Boolean hasEgressIPs() {
    return egressIPs != null && !egressIPs.isEmpty();
  }
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public Boolean hasHost() {
    return this.host != null;
  }
  public String getHostIP() {
    return this.hostIP;
  }
  public A withHostIP(String hostIP) {
    this.hostIP=hostIP; return (A) this;
  }
  public Boolean hasHostIP() {
    return this.hostIP != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public HostSubnetFluentImpl.MetadataNested<A> withNewMetadata() {
    return new HostSubnetFluentImpl.MetadataNestedImpl();
  }
  public HostSubnetFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new HostSubnetFluentImpl.MetadataNestedImpl(item);
  }
  public HostSubnetFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public HostSubnetFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public HostSubnetFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public String getSubnet() {
    return this.subnet;
  }
  public A withSubnet(String subnet) {
    this.subnet=subnet; return (A) this;
  }
  public Boolean hasSubnet() {
    return this.subnet != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HostSubnetFluentImpl that = (HostSubnetFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(egressCIDRs, that.egressCIDRs)) return false;

    if (!java.util.Objects.equals(egressIPs, that.egressIPs)) return false;

    if (!java.util.Objects.equals(host, that.host)) return false;

    if (!java.util.Objects.equals(hostIP, that.hostIP)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(subnet, that.subnet)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  egressCIDRs,  egressIPs,  host,  hostIP,  kind,  metadata,  subnet,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (egressCIDRs != null && !egressCIDRs.isEmpty()) { sb.append("egressCIDRs:"); sb.append(egressCIDRs + ","); }
    if (egressIPs != null && !egressIPs.isEmpty()) { sb.append("egressIPs:"); sb.append(egressIPs + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (hostIP != null) { sb.append("hostIP:"); sb.append(hostIP + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (subnet != null) { sb.append("subnet:"); sb.append(subnet + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<HostSubnetFluentImpl.MetadataNested<N>> implements HostSubnetFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) HostSubnetFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}