package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressNetworkPolicyListBuilder extends EgressNetworkPolicyListFluentImpl<EgressNetworkPolicyListBuilder> implements VisitableBuilder<EgressNetworkPolicyList,EgressNetworkPolicyListBuilder>{
  public EgressNetworkPolicyListBuilder() {
    this(false);
  }
  public EgressNetworkPolicyListBuilder(Boolean validationEnabled) {
    this(new EgressNetworkPolicyList(), validationEnabled);
  }
  public EgressNetworkPolicyListBuilder(EgressNetworkPolicyListFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressNetworkPolicyListBuilder(EgressNetworkPolicyListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressNetworkPolicyList(), validationEnabled);
  }
  public EgressNetworkPolicyListBuilder(EgressNetworkPolicyListFluent<?> fluent,EgressNetworkPolicyList instance) {
    this(fluent, instance, false);
  }
  public EgressNetworkPolicyListBuilder(EgressNetworkPolicyListFluent<?> fluent,EgressNetworkPolicyList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EgressNetworkPolicyListBuilder(EgressNetworkPolicyList instance) {
    this(instance,false);
  }
  public EgressNetworkPolicyListBuilder(EgressNetworkPolicyList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EgressNetworkPolicyListFluent<?> fluent;
  Boolean validationEnabled;
  public EgressNetworkPolicyList build() {
    EgressNetworkPolicyList buildable = new EgressNetworkPolicyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}