package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatus;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterResourceQuotaStatusFluentImpl<A extends ClusterResourceQuotaStatusFluent<A>> extends BaseFluent<A> implements ClusterResourceQuotaStatusFluent<A>{
  public ClusterResourceQuotaStatusFluentImpl() {
  }
  public ClusterResourceQuotaStatusFluentImpl(ClusterResourceQuotaStatus instance) {
    if (instance != null) {
      this.withNamespaces(instance.getNamespaces());
      this.withTotal(instance.getTotal());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ResourceQuotaStatusByNamespaceBuilder> namespaces = new ArrayList<ResourceQuotaStatusByNamespaceBuilder>();
  private ResourceQuotaStatus total;
  private Map<String,Object> additionalProperties;
  public A addToNamespaces(int index,ResourceQuotaStatusByNamespace item) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<ResourceQuotaStatusByNamespaceBuilder>();}
    ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);
    if (index < 0 || index >= namespaces.size()) { _visitables.get("namespaces").add(builder); namespaces.add(builder); } else { _visitables.get("namespaces").add(index, builder); namespaces.add(index, builder);}
    return (A)this;
  }
  public A setToNamespaces(int index,ResourceQuotaStatusByNamespace item) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<ResourceQuotaStatusByNamespaceBuilder>();}
    ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);
    if (index < 0 || index >= namespaces.size()) { _visitables.get("namespaces").add(builder); namespaces.add(builder); } else { _visitables.get("namespaces").set(index, builder); namespaces.set(index, builder);}
    return (A)this;
  }
  public A addToNamespaces(io.fabric8.openshift.api.model.ResourceQuotaStatusByNamespace... items) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<ResourceQuotaStatusByNamespaceBuilder>();}
    for (ResourceQuotaStatusByNamespace item : items) {ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);_visitables.get("namespaces").add(builder);this.namespaces.add(builder);} return (A)this;
  }
  public A addAllToNamespaces(Collection<ResourceQuotaStatusByNamespace> items) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<ResourceQuotaStatusByNamespaceBuilder>();}
    for (ResourceQuotaStatusByNamespace item : items) {ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);_visitables.get("namespaces").add(builder);this.namespaces.add(builder);} return (A)this;
  }
  public A removeFromNamespaces(io.fabric8.openshift.api.model.ResourceQuotaStatusByNamespace... items) {
    for (ResourceQuotaStatusByNamespace item : items) {ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);_visitables.get("namespaces").remove(builder);if (this.namespaces != null) {this.namespaces.remove(builder);}} return (A)this;
  }
  public A removeAllFromNamespaces(Collection<ResourceQuotaStatusByNamespace> items) {
    for (ResourceQuotaStatusByNamespace item : items) {ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);_visitables.get("namespaces").remove(builder);if (this.namespaces != null) {this.namespaces.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNamespaces(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate) {
    if (namespaces == null) return (A) this;
    final Iterator<ResourceQuotaStatusByNamespaceBuilder> each = namespaces.iterator();
    final List visitables = _visitables.get("namespaces");
    while (each.hasNext()) {
      ResourceQuotaStatusByNamespaceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaces instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceQuotaStatusByNamespace> getNamespaces() {
    return namespaces != null ? build(namespaces) : null;
  }
  public List<ResourceQuotaStatusByNamespace> buildNamespaces() {
    return namespaces != null ? build(namespaces) : null;
  }
  public ResourceQuotaStatusByNamespace buildNamespace(int index) {
    return this.namespaces.get(index).build();
  }
  public ResourceQuotaStatusByNamespace buildFirstNamespace() {
    return this.namespaces.get(0).build();
  }
  public ResourceQuotaStatusByNamespace buildLastNamespace() {
    return this.namespaces.get(namespaces.size() - 1).build();
  }
  public ResourceQuotaStatusByNamespace buildMatchingNamespace(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate) {
    for (ResourceQuotaStatusByNamespaceBuilder item: namespaces) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingNamespace(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate) {
    for (ResourceQuotaStatusByNamespaceBuilder item: namespaces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNamespaces(List<ResourceQuotaStatusByNamespace> namespaces) {
    if (this.namespaces != null) { _visitables.get("namespaces").clear();}
    if (namespaces != null) {this.namespaces = new ArrayList(); for (ResourceQuotaStatusByNamespace item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
  }
  public A withNamespaces(io.fabric8.openshift.api.model.ResourceQuotaStatusByNamespace... namespaces) {
    if (this.namespaces != null) {this.namespaces.clear(); _visitables.remove("namespaces"); }
    if (namespaces != null) {for (ResourceQuotaStatusByNamespace item :namespaces){ this.addToNamespaces(item);}} return (A) this;
  }
  public Boolean hasNamespaces() {
    return namespaces != null && !namespaces.isEmpty();
  }
  public ClusterResourceQuotaStatusFluentImpl.NamespacesNested<A> addNewNamespace() {
    return new ClusterResourceQuotaStatusFluentImpl.NamespacesNestedImpl();
  }
  public ClusterResourceQuotaStatusFluentImpl.NamespacesNested<A> addNewNamespaceLike(ResourceQuotaStatusByNamespace item) {
    return new ClusterResourceQuotaStatusFluentImpl.NamespacesNestedImpl(-1, item);
  }
  public ClusterResourceQuotaStatusFluentImpl.NamespacesNested<A> setNewNamespaceLike(int index,ResourceQuotaStatusByNamespace item) {
    return new ClusterResourceQuotaStatusFluentImpl.NamespacesNestedImpl(index, item);
  }
  public ClusterResourceQuotaStatusFluentImpl.NamespacesNested<A> editNamespace(int index) {
    if (namespaces.size() <= index) throw new RuntimeException("Can't edit namespaces. Index exceeds size.");
    return setNewNamespaceLike(index, buildNamespace(index));
  }
  public ClusterResourceQuotaStatusFluentImpl.NamespacesNested<A> editFirstNamespace() {
    if (namespaces.size() == 0) throw new RuntimeException("Can't edit first namespaces. The list is empty.");
    return setNewNamespaceLike(0, buildNamespace(0));
  }
  public ClusterResourceQuotaStatusFluentImpl.NamespacesNested<A> editLastNamespace() {
    int index = namespaces.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last namespaces. The list is empty.");
    return setNewNamespaceLike(index, buildNamespace(index));
  }
  public ClusterResourceQuotaStatusFluentImpl.NamespacesNested<A> editMatchingNamespace(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<namespaces.size();i++) { 
    if (predicate.test(namespaces.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching namespaces. No match found.");
    return setNewNamespaceLike(index, buildNamespace(index));
  }
  public ResourceQuotaStatus getTotal() {
    return this.total;
  }
  public A withTotal(ResourceQuotaStatus total) {
    this.total=total; return (A) this;
  }
  public Boolean hasTotal() {
    return this.total != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterResourceQuotaStatusFluentImpl that = (ClusterResourceQuotaStatusFluentImpl) o;
    if (!java.util.Objects.equals(namespaces, that.namespaces)) return false;

    if (!java.util.Objects.equals(total, that.total)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(namespaces,  total,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (namespaces != null && !namespaces.isEmpty()) { sb.append("namespaces:"); sb.append(namespaces + ","); }
    if (total != null) { sb.append("total:"); sb.append(total + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class NamespacesNestedImpl<N> extends ResourceQuotaStatusByNamespaceFluentImpl<ClusterResourceQuotaStatusFluentImpl.NamespacesNested<N>> implements ClusterResourceQuotaStatusFluentImpl.NamespacesNested<N>,Nested<N>{
    NamespacesNestedImpl(int index,ResourceQuotaStatusByNamespace item) {
      this.index = index;
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this, item);
    }
    NamespacesNestedImpl() {
      this.index = -1;
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this);
    }
    ResourceQuotaStatusByNamespaceBuilder builder;
    int index;
    public N and() {
      return (N) ClusterResourceQuotaStatusFluentImpl.this.setToNamespaces(index,builder.build());
    }
    public N endNamespace() {
      return and();
    }
    
  }
  
}