package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildTriggerPolicyBuilder extends BuildTriggerPolicyFluentImpl<BuildTriggerPolicyBuilder> implements VisitableBuilder<BuildTriggerPolicy,BuildTriggerPolicyBuilder>{
  public BuildTriggerPolicyBuilder() {
    this(false);
  }
  public BuildTriggerPolicyBuilder(Boolean validationEnabled) {
    this(new BuildTriggerPolicy(), validationEnabled);
  }
  public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildTriggerPolicy(), validationEnabled);
  }
  public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent,BuildTriggerPolicy instance) {
    this(fluent, instance, false);
  }
  public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent,BuildTriggerPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBitbucket(instance.getBitbucket());
      fluent.withGeneric(instance.getGeneric());
      fluent.withGithub(instance.getGithub());
      fluent.withGitlab(instance.getGitlab());
      fluent.withImageChange(instance.getImageChange());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildTriggerPolicyBuilder(BuildTriggerPolicy instance) {
    this(instance,false);
  }
  public BuildTriggerPolicyBuilder(BuildTriggerPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBitbucket(instance.getBitbucket());
      this.withGeneric(instance.getGeneric());
      this.withGithub(instance.getGithub());
      this.withGitlab(instance.getGitlab());
      this.withImageChange(instance.getImageChange());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildTriggerPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public BuildTriggerPolicy build() {
    BuildTriggerPolicy buildable = new BuildTriggerPolicy(fluent.getBitbucket(),fluent.getGeneric(),fluent.getGithub(),fluent.getGitlab(),fluent.getImageChange(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}