package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildStrategyBuilder extends BuildStrategyFluentImpl<BuildStrategyBuilder> implements VisitableBuilder<BuildStrategy,BuildStrategyBuilder>{
  public BuildStrategyBuilder() {
    this(false);
  }
  public BuildStrategyBuilder(Boolean validationEnabled) {
    this(new BuildStrategy(), validationEnabled);
  }
  public BuildStrategyBuilder(BuildStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildStrategyBuilder(BuildStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildStrategy(), validationEnabled);
  }
  public BuildStrategyBuilder(BuildStrategyFluent<?> fluent,BuildStrategy instance) {
    this(fluent, instance, false);
  }
  public BuildStrategyBuilder(BuildStrategyFluent<?> fluent,BuildStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCustomStrategy(instance.getCustomStrategy());
      fluent.withDockerStrategy(instance.getDockerStrategy());
      fluent.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy());
      fluent.withSourceStrategy(instance.getSourceStrategy());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildStrategyBuilder(BuildStrategy instance) {
    this(instance,false);
  }
  public BuildStrategyBuilder(BuildStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCustomStrategy(instance.getCustomStrategy());
      this.withDockerStrategy(instance.getDockerStrategy());
      this.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy());
      this.withSourceStrategy(instance.getSourceStrategy());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public BuildStrategy build() {
    BuildStrategy buildable = new BuildStrategy(fluent.getCustomStrategy(),fluent.getDockerStrategy(),fluent.getJenkinsPipelineStrategy(),fluent.getSourceStrategy(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}