package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface BuildConfigSpecFluent<A extends BuildConfigSpecFluent<A>> extends Fluent<A>{
  public Long getCompletionDeadlineSeconds();
  public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds);
  public Boolean hasCompletionDeadlineSeconds();
  public Integer getFailedBuildsHistoryLimit();
  public A withFailedBuildsHistoryLimit(Integer failedBuildsHistoryLimit);
  public Boolean hasFailedBuildsHistoryLimit();
  public Boolean getMountTrustedCA();
  public A withMountTrustedCA(Boolean mountTrustedCA);
  public Boolean hasMountTrustedCA();
  public A addToNodeSelector(String key,String value);
  public A addToNodeSelector(Map<String,String> map);
  public A removeFromNodeSelector(String key);
  public A removeFromNodeSelector(Map<String,String> map);
  public Map<String,String> getNodeSelector();
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector);
  public Boolean hasNodeSelector();
  
  /**
   * This method has been deprecated, please use method buildOutput instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildOutput getOutput();
  public BuildOutput buildOutput();
  public A withOutput(BuildOutput output);
  public Boolean hasOutput();
  public BuildConfigSpecFluent.OutputNested<A> withNewOutput();
  public BuildConfigSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item);
  public BuildConfigSpecFluent.OutputNested<A> editOutput();
  public BuildConfigSpecFluent.OutputNested<A> editOrNewOutput();
  public BuildConfigSpecFluent.OutputNested<A> editOrNewOutputLike(BuildOutput item);
  
  /**
   * This method has been deprecated, please use method buildPostCommit instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildPostCommitSpec getPostCommit();
  public BuildPostCommitSpec buildPostCommit();
  public A withPostCommit(BuildPostCommitSpec postCommit);
  public Boolean hasPostCommit();
  public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommit();
  public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item);
  public BuildConfigSpecFluent.PostCommitNested<A> editPostCommit();
  public BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommit();
  public BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item);
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources();
  public ResourceRequirements buildResources();
  public A withResources(ResourceRequirements resources);
  public Boolean hasResources();
  public BuildConfigSpecFluent.ResourcesNested<A> withNewResources();
  public BuildConfigSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
  public BuildConfigSpecFluent.ResourcesNested<A> editResources();
  public BuildConfigSpecFluent.ResourcesNested<A> editOrNewResources();
  public BuildConfigSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
  
  /**
   * This method has been deprecated, please use method buildRevision instead.
   * @return The buildable object.
   */
  @Deprecated
  public SourceRevision getRevision();
  public SourceRevision buildRevision();
  public A withRevision(SourceRevision revision);
  public Boolean hasRevision();
  public BuildConfigSpecFluent.RevisionNested<A> withNewRevision();
  public BuildConfigSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item);
  public BuildConfigSpecFluent.RevisionNested<A> editRevision();
  public BuildConfigSpecFluent.RevisionNested<A> editOrNewRevision();
  public BuildConfigSpecFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item);
  public String getRunPolicy();
  public A withRunPolicy(String runPolicy);
  public Boolean hasRunPolicy();
  public String getServiceAccount();
  public A withServiceAccount(String serviceAccount);
  public Boolean hasServiceAccount();
  
  /**
   * This method has been deprecated, please use method buildSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildSource getSource();
  public BuildSource buildSource();
  public A withSource(BuildSource source);
  public Boolean hasSource();
  public BuildConfigSpecFluent.SourceNested<A> withNewSource();
  public BuildConfigSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item);
  public BuildConfigSpecFluent.SourceNested<A> editSource();
  public BuildConfigSpecFluent.SourceNested<A> editOrNewSource();
  public BuildConfigSpecFluent.SourceNested<A> editOrNewSourceLike(BuildSource item);
  
  /**
   * This method has been deprecated, please use method buildStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildStrategy getStrategy();
  public BuildStrategy buildStrategy();
  public A withStrategy(BuildStrategy strategy);
  public Boolean hasStrategy();
  public BuildConfigSpecFluent.StrategyNested<A> withNewStrategy();
  public BuildConfigSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item);
  public BuildConfigSpecFluent.StrategyNested<A> editStrategy();
  public BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategy();
  public BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(BuildStrategy item);
  public Integer getSuccessfulBuildsHistoryLimit();
  public A withSuccessfulBuildsHistoryLimit(Integer successfulBuildsHistoryLimit);
  public Boolean hasSuccessfulBuildsHistoryLimit();
  public A addToTriggers(int index,BuildTriggerPolicy item);
  public A setToTriggers(int index,BuildTriggerPolicy item);
  public A addToTriggers(io.fabric8.openshift.api.model.BuildTriggerPolicy... items);
  public A addAllToTriggers(Collection<BuildTriggerPolicy> items);
  public A removeFromTriggers(io.fabric8.openshift.api.model.BuildTriggerPolicy... items);
  public A removeAllFromTriggers(Collection<BuildTriggerPolicy> items);
  public A removeMatchingFromTriggers(Predicate<BuildTriggerPolicyBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildTriggers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BuildTriggerPolicy> getTriggers();
  public List<BuildTriggerPolicy> buildTriggers();
  public BuildTriggerPolicy buildTrigger(int index);
  public BuildTriggerPolicy buildFirstTrigger();
  public BuildTriggerPolicy buildLastTrigger();
  public BuildTriggerPolicy buildMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate);
  public Boolean hasMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate);
  public A withTriggers(List<BuildTriggerPolicy> triggers);
  public A withTriggers(io.fabric8.openshift.api.model.BuildTriggerPolicy... triggers);
  public Boolean hasTriggers();
  public BuildConfigSpecFluent.TriggersNested<A> addNewTrigger();
  public BuildConfigSpecFluent.TriggersNested<A> addNewTriggerLike(BuildTriggerPolicy item);
  public BuildConfigSpecFluent.TriggersNested<A> setNewTriggerLike(int index,BuildTriggerPolicy item);
  public BuildConfigSpecFluent.TriggersNested<A> editTrigger(int index);
  public BuildConfigSpecFluent.TriggersNested<A> editFirstTrigger();
  public BuildConfigSpecFluent.TriggersNested<A> editLastTrigger();
  public BuildConfigSpecFluent.TriggersNested<A> editMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withMountTrustedCA();
  public interface OutputNested<N> extends Nested<N>,BuildOutputFluent<BuildConfigSpecFluent.OutputNested<N>>{
    public N and();
    public N endOutput();
    
  }
  public interface PostCommitNested<N> extends Nested<N>,BuildPostCommitSpecFluent<BuildConfigSpecFluent.PostCommitNested<N>>{
    public N and();
    public N endPostCommit();
    
  }
  public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<BuildConfigSpecFluent.ResourcesNested<N>>{
    public N and();
    public N endResources();
    
  }
  public interface RevisionNested<N> extends Nested<N>,SourceRevisionFluent<BuildConfigSpecFluent.RevisionNested<N>>{
    public N and();
    public N endRevision();
    
  }
  public interface SourceNested<N> extends Nested<N>,BuildSourceFluent<BuildConfigSpecFluent.SourceNested<N>>{
    public N and();
    public N endSource();
    
  }
  public interface StrategyNested<N> extends Nested<N>,BuildStrategyFluent<BuildConfigSpecFluent.StrategyNested<N>>{
    public N and();
    public N endStrategy();
    
  }
  public interface TriggersNested<N> extends Nested<N>,BuildTriggerPolicyFluent<BuildConfigSpecFluent.TriggersNested<N>>{
    public N and();
    public N endTrigger();
    
  }
  
}