package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AppliedClusterResourceQuotaListBuilder extends AppliedClusterResourceQuotaListFluentImpl<AppliedClusterResourceQuotaListBuilder> implements VisitableBuilder<AppliedClusterResourceQuotaList,AppliedClusterResourceQuotaListBuilder>{
  public AppliedClusterResourceQuotaListBuilder() {
    this(false);
  }
  public AppliedClusterResourceQuotaListBuilder(Boolean validationEnabled) {
    this(new AppliedClusterResourceQuotaList(), validationEnabled);
  }
  public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaListFluent<?> fluent) {
    this(fluent, false);
  }
  public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AppliedClusterResourceQuotaList(), validationEnabled);
  }
  public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaListFluent<?> fluent,AppliedClusterResourceQuotaList instance) {
    this(fluent, instance, false);
  }
  public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaListFluent<?> fluent,AppliedClusterResourceQuotaList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaList instance) {
    this(instance,false);
  }
  public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AppliedClusterResourceQuotaListFluent<?> fluent;
  Boolean validationEnabled;
  public AppliedClusterResourceQuotaList build() {
    AppliedClusterResourceQuotaList buildable = new AppliedClusterResourceQuotaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}