package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AllowedFlexVolumeBuilder extends AllowedFlexVolumeFluentImpl<AllowedFlexVolumeBuilder> implements VisitableBuilder<AllowedFlexVolume,AllowedFlexVolumeBuilder>{
  public AllowedFlexVolumeBuilder() {
    this(false);
  }
  public AllowedFlexVolumeBuilder(Boolean validationEnabled) {
    this(new AllowedFlexVolume(), validationEnabled);
  }
  public AllowedFlexVolumeBuilder(AllowedFlexVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public AllowedFlexVolumeBuilder(AllowedFlexVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AllowedFlexVolume(), validationEnabled);
  }
  public AllowedFlexVolumeBuilder(AllowedFlexVolumeFluent<?> fluent,AllowedFlexVolume instance) {
    this(fluent, instance, false);
  }
  public AllowedFlexVolumeBuilder(AllowedFlexVolumeFluent<?> fluent,AllowedFlexVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDriver(instance.getDriver());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AllowedFlexVolumeBuilder(AllowedFlexVolume instance) {
    this(instance,false);
  }
  public AllowedFlexVolumeBuilder(AllowedFlexVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDriver(instance.getDriver());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AllowedFlexVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public AllowedFlexVolume build() {
    AllowedFlexVolume buildable = new AllowedFlexVolume(fluent.getDriver());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}