/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.CompliancePerClusterStatus;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.CompliancePerClusterStatusBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.CompliancePerClusterStatusFluentImpl;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplate;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplateBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplateFluentImpl;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Placement;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementFluentImpl;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyStatus;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PolicyStatusFluentImpl<A extends PolicyStatusFluent<A>>
extends BaseFluent<A>
implements PolicyStatusFluent<A> {
    private String compliant;
    private ArrayList<DetailsPerTemplateBuilder> details = new ArrayList();
    private ArrayList<PlacementBuilder> placement = new ArrayList();
    private ArrayList<CompliancePerClusterStatusBuilder> status = new ArrayList();

    public PolicyStatusFluentImpl() {
    }

    public PolicyStatusFluentImpl(PolicyStatus instance) {
        if (instance != null) {
            this.withCompliant(instance.getCompliant());
            this.withDetails(instance.getDetails());
            this.withPlacement(instance.getPlacement());
            this.withStatus(instance.getStatus());
        }
    }

    @Override
    public String getCompliant() {
        return this.compliant;
    }

    @Override
    public A withCompliant(String compliant) {
        this.compliant = compliant;
        return (A)this;
    }

    @Override
    public Boolean hasCompliant() {
        return this.compliant != null;
    }

    @Override
    public A addToDetails(int index, DetailsPerTemplate item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
        if (index < 0 || index >= this.details.size()) {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        } else {
            this._visitables.get((Object)"details").add(index, builder);
            this.details.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToDetails(int index, DetailsPerTemplate item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
        if (index < 0 || index >= this.details.size()) {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        } else {
            this._visitables.get((Object)"details").set(index, builder);
            this.details.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDetails(DetailsPerTemplate ... items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (DetailsPerTemplate item : items) {
            DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDetails(Collection<DetailsPerTemplate> items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (DetailsPerTemplate item : items) {
            DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDetails(DetailsPerTemplate ... items) {
        for (DetailsPerTemplate item : items) {
            DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").remove(builder);
            if (this.details == null) continue;
            this.details.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDetails(Collection<DetailsPerTemplate> items) {
        for (DetailsPerTemplate item : items) {
            DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").remove(builder);
            if (this.details == null) continue;
            this.details.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDetails(Predicate<DetailsPerTemplateBuilder> predicate) {
        if (this.details == null) {
            return (A)this;
        }
        Iterator<DetailsPerTemplateBuilder> each = this.details.iterator();
        List visitables = this._visitables.get((Object)"details");
        while (each.hasNext()) {
            DetailsPerTemplateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DetailsPerTemplate> getDetails() {
        return this.details != null ? PolicyStatusFluentImpl.build(this.details) : null;
    }

    @Override
    public List<DetailsPerTemplate> buildDetails() {
        return this.details != null ? PolicyStatusFluentImpl.build(this.details) : null;
    }

    @Override
    public DetailsPerTemplate buildDetail(int index) {
        return this.details.get(index).build();
    }

    @Override
    public DetailsPerTemplate buildFirstDetail() {
        return this.details.get(0).build();
    }

    @Override
    public DetailsPerTemplate buildLastDetail() {
        return this.details.get(this.details.size() - 1).build();
    }

    @Override
    public DetailsPerTemplate buildMatchingDetail(Predicate<DetailsPerTemplateBuilder> predicate) {
        for (DetailsPerTemplateBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDetail(Predicate<DetailsPerTemplateBuilder> predicate) {
        for (DetailsPerTemplateBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDetails(List<DetailsPerTemplate> details) {
        if (this.details != null) {
            this._visitables.get((Object)"details").clear();
        }
        if (details != null) {
            this.details = new ArrayList();
            for (DetailsPerTemplate item : details) {
                this.addToDetails(item);
            }
        } else {
            this.details = null;
        }
        return (A)this;
    }

    @Override
    public A withDetails(DetailsPerTemplate ... details) {
        if (this.details != null) {
            this.details.clear();
            this._visitables.remove((Object)"details");
        }
        if (details != null) {
            for (DetailsPerTemplate item : details) {
                this.addToDetails(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDetails() {
        return this.details != null && !this.details.isEmpty();
    }

    @Override
    public PolicyStatusFluent.DetailsNested<A> addNewDetail() {
        return new DetailsNestedImpl();
    }

    @Override
    public PolicyStatusFluent.DetailsNested<A> addNewDetailLike(DetailsPerTemplate item) {
        return new DetailsNestedImpl(-1, item);
    }

    @Override
    public PolicyStatusFluent.DetailsNested<A> setNewDetailLike(int index, DetailsPerTemplate item) {
        return new DetailsNestedImpl(index, item);
    }

    @Override
    public PolicyStatusFluent.DetailsNested<A> editDetail(int index) {
        if (this.details.size() <= index) {
            throw new RuntimeException("Can't edit details. Index exceeds size.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    @Override
    public PolicyStatusFluent.DetailsNested<A> editFirstDetail() {
        if (this.details.size() == 0) {
            throw new RuntimeException("Can't edit first details. The list is empty.");
        }
        return this.setNewDetailLike(0, this.buildDetail(0));
    }

    @Override
    public PolicyStatusFluent.DetailsNested<A> editLastDetail() {
        int index = this.details.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last details. The list is empty.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    @Override
    public PolicyStatusFluent.DetailsNested<A> editMatchingDetail(Predicate<DetailsPerTemplateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.details.size(); ++i) {
            if (!predicate.test(this.details.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching details. No match found.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    @Override
    public A addToPlacement(int index, Placement item) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        PlacementBuilder builder = new PlacementBuilder(item);
        if (index < 0 || index >= this.placement.size()) {
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        } else {
            this._visitables.get((Object)"placement").add(index, builder);
            this.placement.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToPlacement(int index, Placement item) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        PlacementBuilder builder = new PlacementBuilder(item);
        if (index < 0 || index >= this.placement.size()) {
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        } else {
            this._visitables.get((Object)"placement").set(index, builder);
            this.placement.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPlacement(Placement ... items) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPlacement(Collection<Placement> items) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPlacement(Placement ... items) {
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placement").remove(builder);
            if (this.placement == null) continue;
            this.placement.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPlacement(Collection<Placement> items) {
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placement").remove(builder);
            if (this.placement == null) continue;
            this.placement.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPlacement(Predicate<PlacementBuilder> predicate) {
        if (this.placement == null) {
            return (A)this;
        }
        Iterator<PlacementBuilder> each = this.placement.iterator();
        List visitables = this._visitables.get((Object)"placement");
        while (each.hasNext()) {
            PlacementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Placement> getPlacement() {
        return this.placement != null ? PolicyStatusFluentImpl.build(this.placement) : null;
    }

    @Override
    public List<Placement> buildPlacement() {
        return this.placement != null ? PolicyStatusFluentImpl.build(this.placement) : null;
    }

    @Override
    public Placement buildPlacement(int index) {
        return this.placement.get(index).build();
    }

    @Override
    public Placement buildFirstPlacement() {
        return this.placement.get(0).build();
    }

    @Override
    public Placement buildLastPlacement() {
        return this.placement.get(this.placement.size() - 1).build();
    }

    @Override
    public Placement buildMatchingPlacement(Predicate<PlacementBuilder> predicate) {
        for (PlacementBuilder item : this.placement) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPlacement(Predicate<PlacementBuilder> predicate) {
        for (PlacementBuilder item : this.placement) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPlacement(List<Placement> placement) {
        if (this.placement != null) {
            this._visitables.get((Object)"placement").clear();
        }
        if (placement != null) {
            this.placement = new ArrayList();
            for (Placement item : placement) {
                this.addToPlacement(item);
            }
        } else {
            this.placement = null;
        }
        return (A)this;
    }

    @Override
    public A withPlacement(Placement ... placement) {
        if (this.placement != null) {
            this.placement.clear();
            this._visitables.remove((Object)"placement");
        }
        if (placement != null) {
            for (Placement item : placement) {
                this.addToPlacement(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlacement() {
        return this.placement != null && !this.placement.isEmpty();
    }

    @Override
    public PolicyStatusFluent.PlacementNested<A> addNewPlacement() {
        return new PlacementNestedImpl();
    }

    @Override
    public PolicyStatusFluent.PlacementNested<A> addNewPlacementLike(Placement item) {
        return new PlacementNestedImpl(-1, item);
    }

    @Override
    public PolicyStatusFluent.PlacementNested<A> setNewPlacementLike(int index, Placement item) {
        return new PlacementNestedImpl(index, item);
    }

    @Override
    public PolicyStatusFluent.PlacementNested<A> editPlacement(int index) {
        if (this.placement.size() <= index) {
            throw new RuntimeException("Can't edit placement. Index exceeds size.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    @Override
    public PolicyStatusFluent.PlacementNested<A> editFirstPlacement() {
        if (this.placement.size() == 0) {
            throw new RuntimeException("Can't edit first placement. The list is empty.");
        }
        return this.setNewPlacementLike(0, this.buildPlacement(0));
    }

    @Override
    public PolicyStatusFluent.PlacementNested<A> editLastPlacement() {
        int index = this.placement.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last placement. The list is empty.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    @Override
    public PolicyStatusFluent.PlacementNested<A> editMatchingPlacement(Predicate<PlacementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.placement.size(); ++i) {
            if (!predicate.test(this.placement.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching placement. No match found.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    @Override
    public A addToStatus(int index, CompliancePerClusterStatus item) {
        if (this.status == null) {
            this.status = new ArrayList();
        }
        CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
        if (index < 0 || index >= this.status.size()) {
            this._visitables.get((Object)"status").add(builder);
            this.status.add(builder);
        } else {
            this._visitables.get((Object)"status").add(index, builder);
            this.status.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToStatus(int index, CompliancePerClusterStatus item) {
        if (this.status == null) {
            this.status = new ArrayList();
        }
        CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
        if (index < 0 || index >= this.status.size()) {
            this._visitables.get((Object)"status").add(builder);
            this.status.add(builder);
        } else {
            this._visitables.get((Object)"status").set(index, builder);
            this.status.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToStatus(CompliancePerClusterStatus ... items) {
        if (this.status == null) {
            this.status = new ArrayList();
        }
        for (CompliancePerClusterStatus item : items) {
            CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
            this._visitables.get((Object)"status").add(builder);
            this.status.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToStatus(Collection<CompliancePerClusterStatus> items) {
        if (this.status == null) {
            this.status = new ArrayList();
        }
        for (CompliancePerClusterStatus item : items) {
            CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
            this._visitables.get((Object)"status").add(builder);
            this.status.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromStatus(CompliancePerClusterStatus ... items) {
        for (CompliancePerClusterStatus item : items) {
            CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
            this._visitables.get((Object)"status").remove(builder);
            if (this.status == null) continue;
            this.status.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromStatus(Collection<CompliancePerClusterStatus> items) {
        for (CompliancePerClusterStatus item : items) {
            CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
            this._visitables.get((Object)"status").remove(builder);
            if (this.status == null) continue;
            this.status.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
        if (this.status == null) {
            return (A)this;
        }
        Iterator<CompliancePerClusterStatusBuilder> each = this.status.iterator();
        List visitables = this._visitables.get((Object)"status");
        while (each.hasNext()) {
            CompliancePerClusterStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CompliancePerClusterStatus> getStatus() {
        return this.status != null ? PolicyStatusFluentImpl.build(this.status) : null;
    }

    @Override
    public List<CompliancePerClusterStatus> buildStatus() {
        return this.status != null ? PolicyStatusFluentImpl.build(this.status) : null;
    }

    @Override
    public CompliancePerClusterStatus buildStatus(int index) {
        return this.status.get(index).build();
    }

    @Override
    public CompliancePerClusterStatus buildFirstStatus() {
        return this.status.get(0).build();
    }

    @Override
    public CompliancePerClusterStatus buildLastStatus() {
        return this.status.get(this.status.size() - 1).build();
    }

    @Override
    public CompliancePerClusterStatus buildMatchingStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
        for (CompliancePerClusterStatusBuilder item : this.status) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
        for (CompliancePerClusterStatusBuilder item : this.status) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withStatus(List<CompliancePerClusterStatus> status) {
        if (this.status != null) {
            this._visitables.get((Object)"status").clear();
        }
        if (status != null) {
            this.status = new ArrayList();
            for (CompliancePerClusterStatus item : status) {
                this.addToStatus(item);
            }
        } else {
            this.status = null;
        }
        return (A)this;
    }

    @Override
    public A withStatus(CompliancePerClusterStatus ... status) {
        if (this.status != null) {
            this.status.clear();
            this._visitables.remove((Object)"status");
        }
        if (status != null) {
            for (CompliancePerClusterStatus item : status) {
                this.addToStatus(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public A addNewStatus(String clustername, String clusternamespace, String compliant) {
        return this.addToStatus(new CompliancePerClusterStatus(clustername, clusternamespace, compliant));
    }

    @Override
    public PolicyStatusFluent.StatusNested<A> addNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public PolicyStatusFluent.StatusNested<A> addNewStatusLike(CompliancePerClusterStatus item) {
        return new StatusNestedImpl(-1, item);
    }

    @Override
    public PolicyStatusFluent.StatusNested<A> setNewStatusLike(int index, CompliancePerClusterStatus item) {
        return new StatusNestedImpl(index, item);
    }

    @Override
    public PolicyStatusFluent.StatusNested<A> editStatus(int index) {
        if (this.status.size() <= index) {
            throw new RuntimeException("Can't edit status. Index exceeds size.");
        }
        return this.setNewStatusLike(index, this.buildStatus(index));
    }

    @Override
    public PolicyStatusFluent.StatusNested<A> editFirstStatus() {
        if (this.status.size() == 0) {
            throw new RuntimeException("Can't edit first status. The list is empty.");
        }
        return this.setNewStatusLike(0, this.buildStatus(0));
    }

    @Override
    public PolicyStatusFluent.StatusNested<A> editLastStatus() {
        int index = this.status.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last status. The list is empty.");
        }
        return this.setNewStatusLike(index, this.buildStatus(index));
    }

    @Override
    public PolicyStatusFluent.StatusNested<A> editMatchingStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.status.size(); ++i) {
            if (!predicate.test(this.status.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching status. No match found.");
        }
        return this.setNewStatusLike(index, this.buildStatus(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyStatusFluentImpl that = (PolicyStatusFluentImpl)o;
        if (!Objects.equals(this.compliant, that.compliant)) {
            return false;
        }
        if (!Objects.equals(this.details, that.details)) {
            return false;
        }
        if (!Objects.equals(this.placement, that.placement)) {
            return false;
        }
        return Objects.equals(this.status, that.status);
    }

    public int hashCode() {
        return Objects.hash(this.compliant, this.details, this.placement, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.compliant != null) {
            sb.append("compliant:");
            sb.append(this.compliant + ",");
        }
        if (this.details != null) {
            sb.append("details:");
            sb.append(this.details + ",");
        }
        if (this.placement != null) {
            sb.append("placement:");
            sb.append(this.placement + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends CompliancePerClusterStatusFluentImpl<PolicyStatusFluent.StatusNested<N>>
    implements PolicyStatusFluent.StatusNested<N>,
    Nested<N> {
        CompliancePerClusterStatusBuilder builder;
        int index;

        StatusNestedImpl(int index, CompliancePerClusterStatus item) {
            this.index = index;
            this.builder = new CompliancePerClusterStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.index = -1;
            this.builder = new CompliancePerClusterStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyStatusFluentImpl.this.setToStatus(this.index, this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class PlacementNestedImpl<N>
    extends PlacementFluentImpl<PolicyStatusFluent.PlacementNested<N>>
    implements PolicyStatusFluent.PlacementNested<N>,
    Nested<N> {
        PlacementBuilder builder;
        int index;

        PlacementNestedImpl(int index, Placement item) {
            this.index = index;
            this.builder = new PlacementBuilder(this, item);
        }

        PlacementNestedImpl() {
            this.index = -1;
            this.builder = new PlacementBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyStatusFluentImpl.this.setToPlacement(this.index, this.builder.build());
        }

        @Override
        public N endPlacement() {
            return this.and();
        }
    }

    class DetailsNestedImpl<N>
    extends DetailsPerTemplateFluentImpl<PolicyStatusFluent.DetailsNested<N>>
    implements PolicyStatusFluent.DetailsNested<N>,
    Nested<N> {
        DetailsPerTemplateBuilder builder;
        int index;

        DetailsNestedImpl(int index, DetailsPerTemplate item) {
            this.index = index;
            this.builder = new DetailsPerTemplateBuilder(this, item);
        }

        DetailsNestedImpl() {
            this.index = -1;
            this.builder = new DetailsPerTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyStatusFluentImpl.this.setToDetails(this.index, this.builder.build());
        }

        @Override
        public N endDetail() {
            return this.and();
        }
    }
}

