/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicySpec;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicySpecFluent;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplate;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplateBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplateFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PolicySpecFluentImpl<A extends PolicySpecFluent<A>>
extends BaseFluent<A>
implements PolicySpecFluent<A> {
    private Boolean disabled;
    private ArrayList<PolicyTemplateBuilder> policyTemplates = new ArrayList();
    private String remediationAction;

    public PolicySpecFluentImpl() {
    }

    public PolicySpecFluentImpl(PolicySpec instance) {
        if (instance != null) {
            this.withDisabled(instance.getDisabled());
            this.withPolicyTemplates(instance.getPolicyTemplates());
            this.withRemediationAction(instance.getRemediationAction());
        }
    }

    @Override
    public Boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public A withDisabled(Boolean disabled) {
        this.disabled = disabled;
        return (A)this;
    }

    @Override
    public Boolean hasDisabled() {
        return this.disabled != null;
    }

    @Override
    public A addToPolicyTemplates(int index, PolicyTemplate item) {
        if (this.policyTemplates == null) {
            this.policyTemplates = new ArrayList();
        }
        PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
        if (index < 0 || index >= this.policyTemplates.size()) {
            this._visitables.get((Object)"policyTemplates").add(builder);
            this.policyTemplates.add(builder);
        } else {
            this._visitables.get((Object)"policyTemplates").add(index, builder);
            this.policyTemplates.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToPolicyTemplates(int index, PolicyTemplate item) {
        if (this.policyTemplates == null) {
            this.policyTemplates = new ArrayList();
        }
        PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
        if (index < 0 || index >= this.policyTemplates.size()) {
            this._visitables.get((Object)"policyTemplates").add(builder);
            this.policyTemplates.add(builder);
        } else {
            this._visitables.get((Object)"policyTemplates").set(index, builder);
            this.policyTemplates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPolicyTemplates(PolicyTemplate ... items) {
        if (this.policyTemplates == null) {
            this.policyTemplates = new ArrayList();
        }
        for (PolicyTemplate item : items) {
            PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
            this._visitables.get((Object)"policyTemplates").add(builder);
            this.policyTemplates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPolicyTemplates(Collection<PolicyTemplate> items) {
        if (this.policyTemplates == null) {
            this.policyTemplates = new ArrayList();
        }
        for (PolicyTemplate item : items) {
            PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
            this._visitables.get((Object)"policyTemplates").add(builder);
            this.policyTemplates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPolicyTemplates(PolicyTemplate ... items) {
        for (PolicyTemplate item : items) {
            PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
            this._visitables.get((Object)"policyTemplates").remove(builder);
            if (this.policyTemplates == null) continue;
            this.policyTemplates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPolicyTemplates(Collection<PolicyTemplate> items) {
        for (PolicyTemplate item : items) {
            PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
            this._visitables.get((Object)"policyTemplates").remove(builder);
            if (this.policyTemplates == null) continue;
            this.policyTemplates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPolicyTemplates(Predicate<PolicyTemplateBuilder> predicate) {
        if (this.policyTemplates == null) {
            return (A)this;
        }
        Iterator<PolicyTemplateBuilder> each = this.policyTemplates.iterator();
        List visitables = this._visitables.get((Object)"policyTemplates");
        while (each.hasNext()) {
            PolicyTemplateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PolicyTemplate> getPolicyTemplates() {
        return this.policyTemplates != null ? PolicySpecFluentImpl.build(this.policyTemplates) : null;
    }

    @Override
    public List<PolicyTemplate> buildPolicyTemplates() {
        return this.policyTemplates != null ? PolicySpecFluentImpl.build(this.policyTemplates) : null;
    }

    @Override
    public PolicyTemplate buildPolicyTemplate(int index) {
        return this.policyTemplates.get(index).build();
    }

    @Override
    public PolicyTemplate buildFirstPolicyTemplate() {
        return this.policyTemplates.get(0).build();
    }

    @Override
    public PolicyTemplate buildLastPolicyTemplate() {
        return this.policyTemplates.get(this.policyTemplates.size() - 1).build();
    }

    @Override
    public PolicyTemplate buildMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
        for (PolicyTemplateBuilder item : this.policyTemplates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
        for (PolicyTemplateBuilder item : this.policyTemplates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPolicyTemplates(List<PolicyTemplate> policyTemplates) {
        if (this.policyTemplates != null) {
            this._visitables.get((Object)"policyTemplates").clear();
        }
        if (policyTemplates != null) {
            this.policyTemplates = new ArrayList();
            for (PolicyTemplate item : policyTemplates) {
                this.addToPolicyTemplates(item);
            }
        } else {
            this.policyTemplates = null;
        }
        return (A)this;
    }

    @Override
    public A withPolicyTemplates(PolicyTemplate ... policyTemplates) {
        if (this.policyTemplates != null) {
            this.policyTemplates.clear();
            this._visitables.remove((Object)"policyTemplates");
        }
        if (policyTemplates != null) {
            for (PolicyTemplate item : policyTemplates) {
                this.addToPolicyTemplates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicyTemplates() {
        return this.policyTemplates != null && !this.policyTemplates.isEmpty();
    }

    @Override
    public PolicySpecFluent.PolicyTemplatesNested<A> addNewPolicyTemplate() {
        return new PolicyTemplatesNestedImpl();
    }

    @Override
    public PolicySpecFluent.PolicyTemplatesNested<A> addNewPolicyTemplateLike(PolicyTemplate item) {
        return new PolicyTemplatesNestedImpl(-1, item);
    }

    @Override
    public PolicySpecFluent.PolicyTemplatesNested<A> setNewPolicyTemplateLike(int index, PolicyTemplate item) {
        return new PolicyTemplatesNestedImpl(index, item);
    }

    @Override
    public PolicySpecFluent.PolicyTemplatesNested<A> editPolicyTemplate(int index) {
        if (this.policyTemplates.size() <= index) {
            throw new RuntimeException("Can't edit policyTemplates. Index exceeds size.");
        }
        return this.setNewPolicyTemplateLike(index, this.buildPolicyTemplate(index));
    }

    @Override
    public PolicySpecFluent.PolicyTemplatesNested<A> editFirstPolicyTemplate() {
        if (this.policyTemplates.size() == 0) {
            throw new RuntimeException("Can't edit first policyTemplates. The list is empty.");
        }
        return this.setNewPolicyTemplateLike(0, this.buildPolicyTemplate(0));
    }

    @Override
    public PolicySpecFluent.PolicyTemplatesNested<A> editLastPolicyTemplate() {
        int index = this.policyTemplates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last policyTemplates. The list is empty.");
        }
        return this.setNewPolicyTemplateLike(index, this.buildPolicyTemplate(index));
    }

    @Override
    public PolicySpecFluent.PolicyTemplatesNested<A> editMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policyTemplates.size(); ++i) {
            if (!predicate.test(this.policyTemplates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching policyTemplates. No match found.");
        }
        return this.setNewPolicyTemplateLike(index, this.buildPolicyTemplate(index));
    }

    @Override
    public String getRemediationAction() {
        return this.remediationAction;
    }

    @Override
    public A withRemediationAction(String remediationAction) {
        this.remediationAction = remediationAction;
        return (A)this;
    }

    @Override
    public Boolean hasRemediationAction() {
        return this.remediationAction != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicySpecFluentImpl that = (PolicySpecFluentImpl)o;
        if (!Objects.equals(this.disabled, that.disabled)) {
            return false;
        }
        if (!Objects.equals(this.policyTemplates, that.policyTemplates)) {
            return false;
        }
        return Objects.equals(this.remediationAction, that.remediationAction);
    }

    public int hashCode() {
        return Objects.hash(this.disabled, this.policyTemplates, this.remediationAction, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.disabled != null) {
            sb.append("disabled:");
            sb.append(this.disabled + ",");
        }
        if (this.policyTemplates != null) {
            sb.append("policyTemplates:");
            sb.append(this.policyTemplates + ",");
        }
        if (this.remediationAction != null) {
            sb.append("remediationAction:");
            sb.append(this.remediationAction);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withDisabled() {
        return this.withDisabled(true);
    }

    class PolicyTemplatesNestedImpl<N>
    extends PolicyTemplateFluentImpl<PolicySpecFluent.PolicyTemplatesNested<N>>
    implements PolicySpecFluent.PolicyTemplatesNested<N>,
    Nested<N> {
        PolicyTemplateBuilder builder;
        int index;

        PolicyTemplatesNestedImpl(int index, PolicyTemplate item) {
            this.index = index;
            this.builder = new PolicyTemplateBuilder(this, item);
        }

        PolicyTemplatesNestedImpl() {
            this.index = -1;
            this.builder = new PolicyTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicySpecFluentImpl.this.setToPolicyTemplates(this.index, this.builder.build());
        }

        @Override
        public N endPolicyTemplate() {
            return this.and();
        }
    }
}

