package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PolicyStatusFluentImpl<A extends PolicyStatusFluent<A>> extends BaseFluent<A> implements PolicyStatusFluent<A>{
  public PolicyStatusFluentImpl() {
  }
  public PolicyStatusFluentImpl(PolicyStatus instance) {
    if (instance != null) {
      this.withCompliant(instance.getCompliant());
      this.withDetails(instance.getDetails());
      this.withPlacement(instance.getPlacement());
      this.withStatus(instance.getStatus());
    }
  }
  private String compliant;
  private ArrayList<DetailsPerTemplateBuilder> details = new ArrayList<DetailsPerTemplateBuilder>();
  private ArrayList<PlacementBuilder> placement = new ArrayList<PlacementBuilder>();
  private ArrayList<CompliancePerClusterStatusBuilder> status = new ArrayList<CompliancePerClusterStatusBuilder>();
  public String getCompliant() {
    return this.compliant;
  }
  public A withCompliant(String compliant) {
    this.compliant=compliant; return (A) this;
  }
  public Boolean hasCompliant() {
    return this.compliant != null;
  }
  public A addToDetails(int index,DetailsPerTemplate item) {
    if (this.details == null) {this.details = new ArrayList<DetailsPerTemplateBuilder>();}
    DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
    if (index < 0 || index >= details.size()) { _visitables.get("details").add(builder); details.add(builder); } else { _visitables.get("details").add(index, builder); details.add(index, builder);}
    return (A)this;
  }
  public A setToDetails(int index,DetailsPerTemplate item) {
    if (this.details == null) {this.details = new ArrayList<DetailsPerTemplateBuilder>();}
    DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
    if (index < 0 || index >= details.size()) { _visitables.get("details").add(builder); details.add(builder); } else { _visitables.get("details").set(index, builder); details.set(index, builder);}
    return (A)this;
  }
  public A addToDetails(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplate... items) {
    if (this.details == null) {this.details = new ArrayList<DetailsPerTemplateBuilder>();}
    for (DetailsPerTemplate item : items) {DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  public A addAllToDetails(Collection<DetailsPerTemplate> items) {
    if (this.details == null) {this.details = new ArrayList<DetailsPerTemplateBuilder>();}
    for (DetailsPerTemplate item : items) {DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  public A removeFromDetails(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplate... items) {
    for (DetailsPerTemplate item : items) {DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);_visitables.get("details").remove(builder);if (this.details != null) {this.details.remove(builder);}} return (A)this;
  }
  public A removeAllFromDetails(Collection<DetailsPerTemplate> items) {
    for (DetailsPerTemplate item : items) {DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);_visitables.get("details").remove(builder);if (this.details != null) {this.details.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDetails(Predicate<DetailsPerTemplateBuilder> predicate) {
    if (details == null) return (A) this;
    final Iterator<DetailsPerTemplateBuilder> each = details.iterator();
    final List visitables = _visitables.get("details");
    while (each.hasNext()) {
      DetailsPerTemplateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDetails instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DetailsPerTemplate> getDetails() {
    return details != null ? build(details) : null;
  }
  public List<DetailsPerTemplate> buildDetails() {
    return details != null ? build(details) : null;
  }
  public DetailsPerTemplate buildDetail(int index) {
    return this.details.get(index).build();
  }
  public DetailsPerTemplate buildFirstDetail() {
    return this.details.get(0).build();
  }
  public DetailsPerTemplate buildLastDetail() {
    return this.details.get(details.size() - 1).build();
  }
  public DetailsPerTemplate buildMatchingDetail(Predicate<DetailsPerTemplateBuilder> predicate) {
    for (DetailsPerTemplateBuilder item: details) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDetail(Predicate<DetailsPerTemplateBuilder> predicate) {
    for (DetailsPerTemplateBuilder item: details) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDetails(List<DetailsPerTemplate> details) {
    if (this.details != null) { _visitables.get("details").clear();}
    if (details != null) {this.details = new ArrayList(); for (DetailsPerTemplate item : details){this.addToDetails(item);}} else { this.details = null;} return (A) this;
  }
  public A withDetails(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplate... details) {
    if (this.details != null) {this.details.clear(); _visitables.remove("details"); }
    if (details != null) {for (DetailsPerTemplate item :details){ this.addToDetails(item);}} return (A) this;
  }
  public Boolean hasDetails() {
    return details != null && !details.isEmpty();
  }
  public PolicyStatusFluentImpl.DetailsNested<A> addNewDetail() {
    return new PolicyStatusFluentImpl.DetailsNestedImpl();
  }
  public PolicyStatusFluentImpl.DetailsNested<A> addNewDetailLike(DetailsPerTemplate item) {
    return new PolicyStatusFluentImpl.DetailsNestedImpl(-1, item);
  }
  public PolicyStatusFluentImpl.DetailsNested<A> setNewDetailLike(int index,DetailsPerTemplate item) {
    return new PolicyStatusFluentImpl.DetailsNestedImpl(index, item);
  }
  public PolicyStatusFluentImpl.DetailsNested<A> editDetail(int index) {
    if (details.size() <= index) throw new RuntimeException("Can't edit details. Index exceeds size.");
    return setNewDetailLike(index, buildDetail(index));
  }
  public PolicyStatusFluentImpl.DetailsNested<A> editFirstDetail() {
    if (details.size() == 0) throw new RuntimeException("Can't edit first details. The list is empty.");
    return setNewDetailLike(0, buildDetail(0));
  }
  public PolicyStatusFluentImpl.DetailsNested<A> editLastDetail() {
    int index = details.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last details. The list is empty.");
    return setNewDetailLike(index, buildDetail(index));
  }
  public PolicyStatusFluentImpl.DetailsNested<A> editMatchingDetail(Predicate<DetailsPerTemplateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<details.size();i++) { 
    if (predicate.test(details.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching details. No match found.");
    return setNewDetailLike(index, buildDetail(index));
  }
  public A addToPlacement(int index,Placement item) {
    if (this.placement == null) {this.placement = new ArrayList<PlacementBuilder>();}
    PlacementBuilder builder = new PlacementBuilder(item);
    if (index < 0 || index >= placement.size()) { _visitables.get("placement").add(builder); placement.add(builder); } else { _visitables.get("placement").add(index, builder); placement.add(index, builder);}
    return (A)this;
  }
  public A setToPlacement(int index,Placement item) {
    if (this.placement == null) {this.placement = new ArrayList<PlacementBuilder>();}
    PlacementBuilder builder = new PlacementBuilder(item);
    if (index < 0 || index >= placement.size()) { _visitables.get("placement").add(builder); placement.add(builder); } else { _visitables.get("placement").set(index, builder); placement.set(index, builder);}
    return (A)this;
  }
  public A addToPlacement(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Placement... items) {
    if (this.placement == null) {this.placement = new ArrayList<PlacementBuilder>();}
    for (Placement item : items) {PlacementBuilder builder = new PlacementBuilder(item);_visitables.get("placement").add(builder);this.placement.add(builder);} return (A)this;
  }
  public A addAllToPlacement(Collection<Placement> items) {
    if (this.placement == null) {this.placement = new ArrayList<PlacementBuilder>();}
    for (Placement item : items) {PlacementBuilder builder = new PlacementBuilder(item);_visitables.get("placement").add(builder);this.placement.add(builder);} return (A)this;
  }
  public A removeFromPlacement(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Placement... items) {
    for (Placement item : items) {PlacementBuilder builder = new PlacementBuilder(item);_visitables.get("placement").remove(builder);if (this.placement != null) {this.placement.remove(builder);}} return (A)this;
  }
  public A removeAllFromPlacement(Collection<Placement> items) {
    for (Placement item : items) {PlacementBuilder builder = new PlacementBuilder(item);_visitables.get("placement").remove(builder);if (this.placement != null) {this.placement.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPlacement(Predicate<PlacementBuilder> predicate) {
    if (placement == null) return (A) this;
    final Iterator<PlacementBuilder> each = placement.iterator();
    final List visitables = _visitables.get("placement");
    while (each.hasNext()) {
      PlacementBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPlacement instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Placement> getPlacement() {
    return placement != null ? build(placement) : null;
  }
  public List<Placement> buildPlacement() {
    return placement != null ? build(placement) : null;
  }
  public Placement buildPlacement(int index) {
    return this.placement.get(index).build();
  }
  public Placement buildFirstPlacement() {
    return this.placement.get(0).build();
  }
  public Placement buildLastPlacement() {
    return this.placement.get(placement.size() - 1).build();
  }
  public Placement buildMatchingPlacement(Predicate<PlacementBuilder> predicate) {
    for (PlacementBuilder item: placement) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPlacement(Predicate<PlacementBuilder> predicate) {
    for (PlacementBuilder item: placement) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPlacement(List<Placement> placement) {
    if (this.placement != null) { _visitables.get("placement").clear();}
    if (placement != null) {this.placement = new ArrayList(); for (Placement item : placement){this.addToPlacement(item);}} else { this.placement = null;} return (A) this;
  }
  public A withPlacement(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Placement... placement) {
    if (this.placement != null) {this.placement.clear(); _visitables.remove("placement"); }
    if (placement != null) {for (Placement item :placement){ this.addToPlacement(item);}} return (A) this;
  }
  public Boolean hasPlacement() {
    return placement != null && !placement.isEmpty();
  }
  public PolicyStatusFluentImpl.PlacementNested<A> addNewPlacement() {
    return new PolicyStatusFluentImpl.PlacementNestedImpl();
  }
  public PolicyStatusFluentImpl.PlacementNested<A> addNewPlacementLike(Placement item) {
    return new PolicyStatusFluentImpl.PlacementNestedImpl(-1, item);
  }
  public PolicyStatusFluentImpl.PlacementNested<A> setNewPlacementLike(int index,Placement item) {
    return new PolicyStatusFluentImpl.PlacementNestedImpl(index, item);
  }
  public PolicyStatusFluentImpl.PlacementNested<A> editPlacement(int index) {
    if (placement.size() <= index) throw new RuntimeException("Can't edit placement. Index exceeds size.");
    return setNewPlacementLike(index, buildPlacement(index));
  }
  public PolicyStatusFluentImpl.PlacementNested<A> editFirstPlacement() {
    if (placement.size() == 0) throw new RuntimeException("Can't edit first placement. The list is empty.");
    return setNewPlacementLike(0, buildPlacement(0));
  }
  public PolicyStatusFluentImpl.PlacementNested<A> editLastPlacement() {
    int index = placement.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last placement. The list is empty.");
    return setNewPlacementLike(index, buildPlacement(index));
  }
  public PolicyStatusFluentImpl.PlacementNested<A> editMatchingPlacement(Predicate<PlacementBuilder> predicate) {
    int index = -1;
    for (int i=0;i<placement.size();i++) { 
    if (predicate.test(placement.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching placement. No match found.");
    return setNewPlacementLike(index, buildPlacement(index));
  }
  public A addToStatus(int index,CompliancePerClusterStatus item) {
    if (this.status == null) {this.status = new ArrayList<CompliancePerClusterStatusBuilder>();}
    CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
    if (index < 0 || index >= status.size()) { _visitables.get("status").add(builder); status.add(builder); } else { _visitables.get("status").add(index, builder); status.add(index, builder);}
    return (A)this;
  }
  public A setToStatus(int index,CompliancePerClusterStatus item) {
    if (this.status == null) {this.status = new ArrayList<CompliancePerClusterStatusBuilder>();}
    CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
    if (index < 0 || index >= status.size()) { _visitables.get("status").add(builder); status.add(builder); } else { _visitables.get("status").set(index, builder); status.set(index, builder);}
    return (A)this;
  }
  public A addToStatus(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.CompliancePerClusterStatus... items) {
    if (this.status == null) {this.status = new ArrayList<CompliancePerClusterStatusBuilder>();}
    for (CompliancePerClusterStatus item : items) {CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);_visitables.get("status").add(builder);this.status.add(builder);} return (A)this;
  }
  public A addAllToStatus(Collection<CompliancePerClusterStatus> items) {
    if (this.status == null) {this.status = new ArrayList<CompliancePerClusterStatusBuilder>();}
    for (CompliancePerClusterStatus item : items) {CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);_visitables.get("status").add(builder);this.status.add(builder);} return (A)this;
  }
  public A removeFromStatus(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.CompliancePerClusterStatus... items) {
    for (CompliancePerClusterStatus item : items) {CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);_visitables.get("status").remove(builder);if (this.status != null) {this.status.remove(builder);}} return (A)this;
  }
  public A removeAllFromStatus(Collection<CompliancePerClusterStatus> items) {
    for (CompliancePerClusterStatus item : items) {CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);_visitables.get("status").remove(builder);if (this.status != null) {this.status.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
    if (status == null) return (A) this;
    final Iterator<CompliancePerClusterStatusBuilder> each = status.iterator();
    final List visitables = _visitables.get("status");
    while (each.hasNext()) {
      CompliancePerClusterStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CompliancePerClusterStatus> getStatus() {
    return status != null ? build(status) : null;
  }
  public List<CompliancePerClusterStatus> buildStatus() {
    return status != null ? build(status) : null;
  }
  public CompliancePerClusterStatus buildStatus(int index) {
    return this.status.get(index).build();
  }
  public CompliancePerClusterStatus buildFirstStatus() {
    return this.status.get(0).build();
  }
  public CompliancePerClusterStatus buildLastStatus() {
    return this.status.get(status.size() - 1).build();
  }
  public CompliancePerClusterStatus buildMatchingStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
    for (CompliancePerClusterStatusBuilder item: status) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
    for (CompliancePerClusterStatusBuilder item: status) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withStatus(List<CompliancePerClusterStatus> status) {
    if (this.status != null) { _visitables.get("status").clear();}
    if (status != null) {this.status = new ArrayList(); for (CompliancePerClusterStatus item : status){this.addToStatus(item);}} else { this.status = null;} return (A) this;
  }
  public A withStatus(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.CompliancePerClusterStatus... status) {
    if (this.status != null) {this.status.clear(); _visitables.remove("status"); }
    if (status != null) {for (CompliancePerClusterStatus item :status){ this.addToStatus(item);}} return (A) this;
  }
  public Boolean hasStatus() {
    return status != null && !status.isEmpty();
  }
  public A addNewStatus(String clustername,String clusternamespace,String compliant) {
    return (A)addToStatus(new CompliancePerClusterStatus(clustername, clusternamespace, compliant));
  }
  public PolicyStatusFluentImpl.StatusNested<A> addNewStatus() {
    return new PolicyStatusFluentImpl.StatusNestedImpl();
  }
  public PolicyStatusFluentImpl.StatusNested<A> addNewStatusLike(CompliancePerClusterStatus item) {
    return new PolicyStatusFluentImpl.StatusNestedImpl(-1, item);
  }
  public PolicyStatusFluentImpl.StatusNested<A> setNewStatusLike(int index,CompliancePerClusterStatus item) {
    return new PolicyStatusFluentImpl.StatusNestedImpl(index, item);
  }
  public PolicyStatusFluentImpl.StatusNested<A> editStatus(int index) {
    if (status.size() <= index) throw new RuntimeException("Can't edit status. Index exceeds size.");
    return setNewStatusLike(index, buildStatus(index));
  }
  public PolicyStatusFluentImpl.StatusNested<A> editFirstStatus() {
    if (status.size() == 0) throw new RuntimeException("Can't edit first status. The list is empty.");
    return setNewStatusLike(0, buildStatus(0));
  }
  public PolicyStatusFluentImpl.StatusNested<A> editLastStatus() {
    int index = status.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last status. The list is empty.");
    return setNewStatusLike(index, buildStatus(index));
  }
  public PolicyStatusFluentImpl.StatusNested<A> editMatchingStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<status.size();i++) { 
    if (predicate.test(status.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching status. No match found.");
    return setNewStatusLike(index, buildStatus(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PolicyStatusFluentImpl that = (PolicyStatusFluentImpl) o;
    if (!java.util.Objects.equals(compliant, that.compliant)) return false;

    if (!java.util.Objects.equals(details, that.details)) return false;

    if (!java.util.Objects.equals(placement, that.placement)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(compliant,  details,  placement,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (compliant != null) { sb.append("compliant:"); sb.append(compliant + ","); }
    if (details != null) { sb.append("details:"); sb.append(details + ","); }
    if (placement != null) { sb.append("placement:"); sb.append(placement + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class DetailsNestedImpl<N> extends DetailsPerTemplateFluentImpl<PolicyStatusFluentImpl.DetailsNested<N>> implements PolicyStatusFluentImpl.DetailsNested<N>,Nested<N>{
    DetailsNestedImpl(int index,DetailsPerTemplate item) {
      this.index = index;
      this.builder = new DetailsPerTemplateBuilder(this, item);
    }
    DetailsNestedImpl() {
      this.index = -1;
      this.builder = new DetailsPerTemplateBuilder(this);
    }
    DetailsPerTemplateBuilder builder;
    int index;
    public N and() {
      return (N) PolicyStatusFluentImpl.this.setToDetails(index,builder.build());
    }
    public N endDetail() {
      return and();
    }
    
  }
  class PlacementNestedImpl<N> extends PlacementFluentImpl<PolicyStatusFluentImpl.PlacementNested<N>> implements PolicyStatusFluentImpl.PlacementNested<N>,Nested<N>{
    PlacementNestedImpl(int index,Placement item) {
      this.index = index;
      this.builder = new PlacementBuilder(this, item);
    }
    PlacementNestedImpl() {
      this.index = -1;
      this.builder = new PlacementBuilder(this);
    }
    PlacementBuilder builder;
    int index;
    public N and() {
      return (N) PolicyStatusFluentImpl.this.setToPlacement(index,builder.build());
    }
    public N endPlacement() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends CompliancePerClusterStatusFluentImpl<PolicyStatusFluentImpl.StatusNested<N>> implements PolicyStatusFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(int index,CompliancePerClusterStatus item) {
      this.index = index;
      this.builder = new CompliancePerClusterStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.index = -1;
      this.builder = new CompliancePerClusterStatusBuilder(this);
    }
    CompliancePerClusterStatusBuilder builder;
    int index;
    public N and() {
      return (N) PolicyStatusFluentImpl.this.setToStatus(index,builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}