package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PolicySpecFluentImpl<A extends PolicySpecFluent<A>> extends BaseFluent<A> implements PolicySpecFluent<A>{
  public PolicySpecFluentImpl() {
  }
  public PolicySpecFluentImpl(PolicySpec instance) {
    if (instance != null) {
      this.withDisabled(instance.getDisabled());
      this.withPolicyTemplates(instance.getPolicyTemplates());
      this.withRemediationAction(instance.getRemediationAction());
    }
  }
  private Boolean disabled;
  private ArrayList<PolicyTemplateBuilder> policyTemplates = new ArrayList<PolicyTemplateBuilder>();
  private String remediationAction;
  public Boolean getDisabled() {
    return this.disabled;
  }
  public A withDisabled(Boolean disabled) {
    this.disabled=disabled; return (A) this;
  }
  public Boolean hasDisabled() {
    return this.disabled != null;
  }
  public A addToPolicyTemplates(int index,PolicyTemplate item) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
    if (index < 0 || index >= policyTemplates.size()) { _visitables.get("policyTemplates").add(builder); policyTemplates.add(builder); } else { _visitables.get("policyTemplates").add(index, builder); policyTemplates.add(index, builder);}
    return (A)this;
  }
  public A setToPolicyTemplates(int index,PolicyTemplate item) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
    if (index < 0 || index >= policyTemplates.size()) { _visitables.get("policyTemplates").add(builder); policyTemplates.add(builder); } else { _visitables.get("policyTemplates").set(index, builder); policyTemplates.set(index, builder);}
    return (A)this;
  }
  public A addToPolicyTemplates(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplate... items) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").add(builder);this.policyTemplates.add(builder);} return (A)this;
  }
  public A addAllToPolicyTemplates(Collection<PolicyTemplate> items) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").add(builder);this.policyTemplates.add(builder);} return (A)this;
  }
  public A removeFromPolicyTemplates(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplate... items) {
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").remove(builder);if (this.policyTemplates != null) {this.policyTemplates.remove(builder);}} return (A)this;
  }
  public A removeAllFromPolicyTemplates(Collection<PolicyTemplate> items) {
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").remove(builder);if (this.policyTemplates != null) {this.policyTemplates.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPolicyTemplates(Predicate<PolicyTemplateBuilder> predicate) {
    if (policyTemplates == null) return (A) this;
    final Iterator<PolicyTemplateBuilder> each = policyTemplates.iterator();
    final List visitables = _visitables.get("policyTemplates");
    while (each.hasNext()) {
      PolicyTemplateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPolicyTemplates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PolicyTemplate> getPolicyTemplates() {
    return policyTemplates != null ? build(policyTemplates) : null;
  }
  public List<PolicyTemplate> buildPolicyTemplates() {
    return policyTemplates != null ? build(policyTemplates) : null;
  }
  public PolicyTemplate buildPolicyTemplate(int index) {
    return this.policyTemplates.get(index).build();
  }
  public PolicyTemplate buildFirstPolicyTemplate() {
    return this.policyTemplates.get(0).build();
  }
  public PolicyTemplate buildLastPolicyTemplate() {
    return this.policyTemplates.get(policyTemplates.size() - 1).build();
  }
  public PolicyTemplate buildMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
    for (PolicyTemplateBuilder item: policyTemplates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
    for (PolicyTemplateBuilder item: policyTemplates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPolicyTemplates(List<PolicyTemplate> policyTemplates) {
    if (this.policyTemplates != null) { _visitables.get("policyTemplates").clear();}
    if (policyTemplates != null) {this.policyTemplates = new ArrayList(); for (PolicyTemplate item : policyTemplates){this.addToPolicyTemplates(item);}} else { this.policyTemplates = null;} return (A) this;
  }
  public A withPolicyTemplates(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplate... policyTemplates) {
    if (this.policyTemplates != null) {this.policyTemplates.clear(); _visitables.remove("policyTemplates"); }
    if (policyTemplates != null) {for (PolicyTemplate item :policyTemplates){ this.addToPolicyTemplates(item);}} return (A) this;
  }
  public Boolean hasPolicyTemplates() {
    return policyTemplates != null && !policyTemplates.isEmpty();
  }
  public PolicySpecFluentImpl.PolicyTemplatesNested<A> addNewPolicyTemplate() {
    return new PolicySpecFluentImpl.PolicyTemplatesNestedImpl();
  }
  public PolicySpecFluentImpl.PolicyTemplatesNested<A> addNewPolicyTemplateLike(PolicyTemplate item) {
    return new PolicySpecFluentImpl.PolicyTemplatesNestedImpl(-1, item);
  }
  public PolicySpecFluentImpl.PolicyTemplatesNested<A> setNewPolicyTemplateLike(int index,PolicyTemplate item) {
    return new PolicySpecFluentImpl.PolicyTemplatesNestedImpl(index, item);
  }
  public PolicySpecFluentImpl.PolicyTemplatesNested<A> editPolicyTemplate(int index) {
    if (policyTemplates.size() <= index) throw new RuntimeException("Can't edit policyTemplates. Index exceeds size.");
    return setNewPolicyTemplateLike(index, buildPolicyTemplate(index));
  }
  public PolicySpecFluentImpl.PolicyTemplatesNested<A> editFirstPolicyTemplate() {
    if (policyTemplates.size() == 0) throw new RuntimeException("Can't edit first policyTemplates. The list is empty.");
    return setNewPolicyTemplateLike(0, buildPolicyTemplate(0));
  }
  public PolicySpecFluentImpl.PolicyTemplatesNested<A> editLastPolicyTemplate() {
    int index = policyTemplates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last policyTemplates. The list is empty.");
    return setNewPolicyTemplateLike(index, buildPolicyTemplate(index));
  }
  public PolicySpecFluentImpl.PolicyTemplatesNested<A> editMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<policyTemplates.size();i++) { 
    if (predicate.test(policyTemplates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching policyTemplates. No match found.");
    return setNewPolicyTemplateLike(index, buildPolicyTemplate(index));
  }
  public String getRemediationAction() {
    return this.remediationAction;
  }
  public A withRemediationAction(String remediationAction) {
    this.remediationAction=remediationAction; return (A) this;
  }
  public Boolean hasRemediationAction() {
    return this.remediationAction != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PolicySpecFluentImpl that = (PolicySpecFluentImpl) o;
    if (!java.util.Objects.equals(disabled, that.disabled)) return false;

    if (!java.util.Objects.equals(policyTemplates, that.policyTemplates)) return false;

    if (!java.util.Objects.equals(remediationAction, that.remediationAction)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(disabled,  policyTemplates,  remediationAction,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (disabled != null) { sb.append("disabled:"); sb.append(disabled + ","); }
    if (policyTemplates != null) { sb.append("policyTemplates:"); sb.append(policyTemplates + ","); }
    if (remediationAction != null) { sb.append("remediationAction:"); sb.append(remediationAction); }
    sb.append("}");
    return sb.toString();
  }
  public A withDisabled() {
    return withDisabled(true);
  }
  class PolicyTemplatesNestedImpl<N> extends PolicyTemplateFluentImpl<PolicySpecFluentImpl.PolicyTemplatesNested<N>> implements PolicySpecFluentImpl.PolicyTemplatesNested<N>,Nested<N>{
    PolicyTemplatesNestedImpl(int index,PolicyTemplate item) {
      this.index = index;
      this.builder = new PolicyTemplateBuilder(this, item);
    }
    PolicyTemplatesNestedImpl() {
      this.index = -1;
      this.builder = new PolicyTemplateBuilder(this);
    }
    PolicyTemplateBuilder builder;
    int index;
    public N and() {
      return (N) PolicySpecFluentImpl.this.setToPolicyTemplates(index,builder.build());
    }
    public N endPolicyTemplate() {
      return and();
    }
    
  }
  
}