package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PolicyFluentImpl<A extends PolicyFluent<A>> extends BaseFluent<A> implements PolicyFluent<A>{
  public PolicyFluentImpl() {
  }
  public PolicyFluentImpl(Policy instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private PolicySpecBuilder spec;
  private PolicyStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public PolicyFluentImpl.MetadataNested<A> withNewMetadata() {
    return new PolicyFluentImpl.MetadataNestedImpl();
  }
  public PolicyFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new PolicyFluentImpl.MetadataNestedImpl(item);
  }
  public PolicyFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public PolicyFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public PolicyFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public PolicySpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public PolicySpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(PolicySpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new PolicySpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public PolicyFluentImpl.SpecNested<A> withNewSpec() {
    return new PolicyFluentImpl.SpecNestedImpl();
  }
  public PolicyFluentImpl.SpecNested<A> withNewSpecLike(PolicySpec item) {
    return new PolicyFluentImpl.SpecNestedImpl(item);
  }
  public PolicyFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public PolicyFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new PolicySpecBuilder().build());
  }
  public PolicyFluentImpl.SpecNested<A> editOrNewSpecLike(PolicySpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public PolicyStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public PolicyStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(PolicyStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new PolicyStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public PolicyFluentImpl.StatusNested<A> withNewStatus() {
    return new PolicyFluentImpl.StatusNestedImpl();
  }
  public PolicyFluentImpl.StatusNested<A> withNewStatusLike(PolicyStatus item) {
    return new PolicyFluentImpl.StatusNestedImpl(item);
  }
  public PolicyFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public PolicyFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new PolicyStatusBuilder().build());
  }
  public PolicyFluentImpl.StatusNested<A> editOrNewStatusLike(PolicyStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PolicyFluentImpl that = (PolicyFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PolicyFluentImpl.MetadataNested<N>> implements PolicyFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) PolicyFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends PolicySpecFluentImpl<PolicyFluentImpl.SpecNested<N>> implements PolicyFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(PolicySpec item) {
      this.builder = new PolicySpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new PolicySpecBuilder(this);
    }
    PolicySpecBuilder builder;
    public N and() {
      return (N) PolicyFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends PolicyStatusFluentImpl<PolicyFluentImpl.StatusNested<N>> implements PolicyFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(PolicyStatus item) {
      this.builder = new PolicyStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new PolicyStatusBuilder(this);
    }
    PolicyStatusBuilder builder;
    public N and() {
      return (N) PolicyFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}