package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PolicyBuilder extends PolicyFluentImpl<PolicyBuilder> implements VisitableBuilder<Policy,PolicyBuilder>{
  public PolicyBuilder() {
    this(false);
  }
  public PolicyBuilder(Boolean validationEnabled) {
    this(new Policy(), validationEnabled);
  }
  public PolicyBuilder(PolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public PolicyBuilder(PolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Policy(), validationEnabled);
  }
  public PolicyBuilder(PolicyFluent<?> fluent,Policy instance) {
    this(fluent, instance, false);
  }
  public PolicyBuilder(PolicyFluent<?> fluent,Policy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PolicyBuilder(Policy instance) {
    this(instance,false);
  }
  public PolicyBuilder(Policy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PolicyFluent<?> fluent;
  Boolean validationEnabled;
  public Policy build() {
    Policy buildable = new Policy(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}