package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlacementBindingFluentImpl<A extends PlacementBindingFluent<A>> extends BaseFluent<A> implements PlacementBindingFluent<A>{
  public PlacementBindingFluentImpl() {
  }
  public PlacementBindingFluentImpl(PlacementBinding instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withPlacementRef(instance.getPlacementRef());
      this.withStatus(instance.getStatus());
      this.withSubjects(instance.getSubjects());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private PlacementSubjectBuilder placementRef;
  private PlacementBindingStatusBuilder status;
  private ArrayList<SubjectBuilder> subjects = new ArrayList<SubjectBuilder>();
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public PlacementBindingFluentImpl.MetadataNested<A> withNewMetadata() {
    return new PlacementBindingFluentImpl.MetadataNestedImpl();
  }
  public PlacementBindingFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new PlacementBindingFluentImpl.MetadataNestedImpl(item);
  }
  public PlacementBindingFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public PlacementBindingFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public PlacementBindingFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPlacementRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public PlacementSubject getPlacementRef() {
    return this.placementRef!=null ?this.placementRef.build():null;
  }
  public PlacementSubject buildPlacementRef() {
    return this.placementRef!=null ?this.placementRef.build():null;
  }
  public A withPlacementRef(PlacementSubject placementRef) {
    _visitables.get("placementRef").remove(this.placementRef);
    if (placementRef!=null){ this.placementRef= new PlacementSubjectBuilder(placementRef); _visitables.get("placementRef").add(this.placementRef);} else { this.placementRef = null; _visitables.get("placementRef").remove(this.placementRef); } return (A) this;
  }
  public Boolean hasPlacementRef() {
    return this.placementRef != null;
  }
  public A withNewPlacementRef(String apiGroup,String kind,String name) {
    return (A)withPlacementRef(new PlacementSubject(apiGroup, kind, name));
  }
  public PlacementBindingFluentImpl.PlacementRefNested<A> withNewPlacementRef() {
    return new PlacementBindingFluentImpl.PlacementRefNestedImpl();
  }
  public PlacementBindingFluentImpl.PlacementRefNested<A> withNewPlacementRefLike(PlacementSubject item) {
    return new PlacementBindingFluentImpl.PlacementRefNestedImpl(item);
  }
  public PlacementBindingFluentImpl.PlacementRefNested<A> editPlacementRef() {
    return withNewPlacementRefLike(getPlacementRef());
  }
  public PlacementBindingFluentImpl.PlacementRefNested<A> editOrNewPlacementRef() {
    return withNewPlacementRefLike(getPlacementRef() != null ? getPlacementRef(): new PlacementSubjectBuilder().build());
  }
  public PlacementBindingFluentImpl.PlacementRefNested<A> editOrNewPlacementRefLike(PlacementSubject item) {
    return withNewPlacementRefLike(getPlacementRef() != null ? getPlacementRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public PlacementBindingStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public PlacementBindingStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(PlacementBindingStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new PlacementBindingStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public PlacementBindingFluentImpl.StatusNested<A> withNewStatus() {
    return new PlacementBindingFluentImpl.StatusNestedImpl();
  }
  public PlacementBindingFluentImpl.StatusNested<A> withNewStatusLike(PlacementBindingStatus item) {
    return new PlacementBindingFluentImpl.StatusNestedImpl(item);
  }
  public PlacementBindingFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public PlacementBindingFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new PlacementBindingStatusBuilder().build());
  }
  public PlacementBindingFluentImpl.StatusNested<A> editOrNewStatusLike(PlacementBindingStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToSubjects(int index,Subject item) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    SubjectBuilder builder = new SubjectBuilder(item);
    if (index < 0 || index >= subjects.size()) { _visitables.get("subjects").add(builder); subjects.add(builder); } else { _visitables.get("subjects").add(index, builder); subjects.add(index, builder);}
    return (A)this;
  }
  public A setToSubjects(int index,Subject item) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    SubjectBuilder builder = new SubjectBuilder(item);
    if (index < 0 || index >= subjects.size()) { _visitables.get("subjects").add(builder); subjects.add(builder); } else { _visitables.get("subjects").set(index, builder); subjects.set(index, builder);}
    return (A)this;
  }
  public A addToSubjects(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Subject... items) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A addAllToSubjects(Collection<Subject> items) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A removeFromSubjects(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Subject... items) {
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubjects(Collection<Subject> items) {
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubjects(Predicate<SubjectBuilder> predicate) {
    if (subjects == null) return (A) this;
    final Iterator<SubjectBuilder> each = subjects.iterator();
    final List visitables = _visitables.get("subjects");
    while (each.hasNext()) {
      SubjectBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubjects instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Subject> getSubjects() {
    return subjects != null ? build(subjects) : null;
  }
  public List<Subject> buildSubjects() {
    return subjects != null ? build(subjects) : null;
  }
  public Subject buildSubject(int index) {
    return this.subjects.get(index).build();
  }
  public Subject buildFirstSubject() {
    return this.subjects.get(0).build();
  }
  public Subject buildLastSubject() {
    return this.subjects.get(subjects.size() - 1).build();
  }
  public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
    for (SubjectBuilder item: subjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSubject(Predicate<SubjectBuilder> predicate) {
    for (SubjectBuilder item: subjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubjects(List<Subject> subjects) {
    if (this.subjects != null) { _visitables.get("subjects").clear();}
    if (subjects != null) {this.subjects = new ArrayList(); for (Subject item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
  }
  public A withSubjects(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Subject... subjects) {
    if (this.subjects != null) {this.subjects.clear(); _visitables.remove("subjects"); }
    if (subjects != null) {for (Subject item :subjects){ this.addToSubjects(item);}} return (A) this;
  }
  public Boolean hasSubjects() {
    return subjects != null && !subjects.isEmpty();
  }
  public A addNewSubject(String apiGroup,String kind,String name) {
    return (A)addToSubjects(new Subject(apiGroup, kind, name));
  }
  public PlacementBindingFluentImpl.SubjectsNested<A> addNewSubject() {
    return new PlacementBindingFluentImpl.SubjectsNestedImpl();
  }
  public PlacementBindingFluentImpl.SubjectsNested<A> addNewSubjectLike(Subject item) {
    return new PlacementBindingFluentImpl.SubjectsNestedImpl(-1, item);
  }
  public PlacementBindingFluentImpl.SubjectsNested<A> setNewSubjectLike(int index,Subject item) {
    return new PlacementBindingFluentImpl.SubjectsNestedImpl(index, item);
  }
  public PlacementBindingFluentImpl.SubjectsNested<A> editSubject(int index) {
    if (subjects.size() <= index) throw new RuntimeException("Can't edit subjects. Index exceeds size.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public PlacementBindingFluentImpl.SubjectsNested<A> editFirstSubject() {
    if (subjects.size() == 0) throw new RuntimeException("Can't edit first subjects. The list is empty.");
    return setNewSubjectLike(0, buildSubject(0));
  }
  public PlacementBindingFluentImpl.SubjectsNested<A> editLastSubject() {
    int index = subjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subjects. The list is empty.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public PlacementBindingFluentImpl.SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subjects.size();i++) { 
    if (predicate.test(subjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subjects. No match found.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlacementBindingFluentImpl that = (PlacementBindingFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(placementRef, that.placementRef)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    if (!java.util.Objects.equals(subjects, that.subjects)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  placementRef,  status,  subjects,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (placementRef != null) { sb.append("placementRef:"); sb.append(placementRef + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (subjects != null) { sb.append("subjects:"); sb.append(subjects); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PlacementBindingFluentImpl.MetadataNested<N>> implements PlacementBindingFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) PlacementBindingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class PlacementRefNestedImpl<N> extends PlacementSubjectFluentImpl<PlacementBindingFluentImpl.PlacementRefNested<N>> implements PlacementBindingFluentImpl.PlacementRefNested<N>,Nested<N>{
    PlacementRefNestedImpl(PlacementSubject item) {
      this.builder = new PlacementSubjectBuilder(this, item);
    }
    PlacementRefNestedImpl() {
      this.builder = new PlacementSubjectBuilder(this);
    }
    PlacementSubjectBuilder builder;
    public N and() {
      return (N) PlacementBindingFluentImpl.this.withPlacementRef(builder.build());
    }
    public N endPlacementRef() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends PlacementBindingStatusFluentImpl<PlacementBindingFluentImpl.StatusNested<N>> implements PlacementBindingFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(PlacementBindingStatus item) {
      this.builder = new PlacementBindingStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new PlacementBindingStatusBuilder(this);
    }
    PlacementBindingStatusBuilder builder;
    public N and() {
      return (N) PlacementBindingFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  class SubjectsNestedImpl<N> extends SubjectFluentImpl<PlacementBindingFluentImpl.SubjectsNested<N>> implements PlacementBindingFluentImpl.SubjectsNested<N>,Nested<N>{
    SubjectsNestedImpl(int index,Subject item) {
      this.index = index;
      this.builder = new SubjectBuilder(this, item);
    }
    SubjectsNestedImpl() {
      this.index = -1;
      this.builder = new SubjectBuilder(this);
    }
    SubjectBuilder builder;
    int index;
    public N and() {
      return (N) PlacementBindingFluentImpl.this.setToSubjects(index,builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}