package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DetailsPerTemplateBuilder extends DetailsPerTemplateFluentImpl<DetailsPerTemplateBuilder> implements VisitableBuilder<DetailsPerTemplate,DetailsPerTemplateBuilder>{
  public DetailsPerTemplateBuilder() {
    this(false);
  }
  public DetailsPerTemplateBuilder(Boolean validationEnabled) {
    this(new DetailsPerTemplate(), validationEnabled);
  }
  public DetailsPerTemplateBuilder(DetailsPerTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public DetailsPerTemplateBuilder(DetailsPerTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DetailsPerTemplate(), validationEnabled);
  }
  public DetailsPerTemplateBuilder(DetailsPerTemplateFluent<?> fluent,DetailsPerTemplate instance) {
    this(fluent, instance, false);
  }
  public DetailsPerTemplateBuilder(DetailsPerTemplateFluent<?> fluent,DetailsPerTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCompliant(instance.getCompliant());
      fluent.withHistory(instance.getHistory());
      fluent.withTemplateMeta(instance.getTemplateMeta());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DetailsPerTemplateBuilder(DetailsPerTemplate instance) {
    this(instance,false);
  }
  public DetailsPerTemplateBuilder(DetailsPerTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCompliant(instance.getCompliant());
      this.withHistory(instance.getHistory());
      this.withTemplateMeta(instance.getTemplateMeta());
    }
    this.validationEnabled = validationEnabled; 
  }
  DetailsPerTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public DetailsPerTemplate build() {
    DetailsPerTemplate buildable = new DetailsPerTemplate(fluent.getCompliant(),fluent.getHistory(),fluent.getTemplateMeta());
    return buildable;
  }
  
}