package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CompliancePerClusterStatusBuilder extends CompliancePerClusterStatusFluentImpl<CompliancePerClusterStatusBuilder> implements VisitableBuilder<CompliancePerClusterStatus,CompliancePerClusterStatusBuilder>{
  public CompliancePerClusterStatusBuilder() {
    this(false);
  }
  public CompliancePerClusterStatusBuilder(Boolean validationEnabled) {
    this(new CompliancePerClusterStatus(), validationEnabled);
  }
  public CompliancePerClusterStatusBuilder(CompliancePerClusterStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CompliancePerClusterStatusBuilder(CompliancePerClusterStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CompliancePerClusterStatus(), validationEnabled);
  }
  public CompliancePerClusterStatusBuilder(CompliancePerClusterStatusFluent<?> fluent,CompliancePerClusterStatus instance) {
    this(fluent, instance, false);
  }
  public CompliancePerClusterStatusBuilder(CompliancePerClusterStatusFluent<?> fluent,CompliancePerClusterStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClustername(instance.getClustername());
      fluent.withClusternamespace(instance.getClusternamespace());
      fluent.withCompliant(instance.getCompliant());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CompliancePerClusterStatusBuilder(CompliancePerClusterStatus instance) {
    this(instance,false);
  }
  public CompliancePerClusterStatusBuilder(CompliancePerClusterStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClustername(instance.getClustername());
      this.withClusternamespace(instance.getClusternamespace());
      this.withCompliant(instance.getCompliant());
    }
    this.validationEnabled = validationEnabled; 
  }
  CompliancePerClusterStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CompliancePerClusterStatus build() {
    CompliancePerClusterStatus buildable = new CompliancePerClusterStatus(fluent.getClustername(),fluent.getClusternamespace(),fluent.getCompliant());
    return buildable;
  }
  
}