/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.ClusterConditionFilter;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.ClusterConditionFilterBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.ClusterConditionFilterFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.GenericClusterReference;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.GenericClusterReferenceBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.GenericClusterReferenceFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.PlacementRuleSpec;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.ResourceHint;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.ResourceHintBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.ResourceHintFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlacementRuleSpecFluent<A extends PlacementRuleSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ClusterConditionFilterBuilder> clusterConditions = new ArrayList();
    private Integer clusterReplicas;
    private LabelSelectorBuilder clusterSelector;
    private ArrayList<GenericClusterReferenceBuilder> clusters = new ArrayList();
    private ArrayList<ObjectReferenceBuilder> policies = new ArrayList();
    private ResourceHintBuilder resourceHint;
    private String schedulerName;

    public PlacementRuleSpecFluent() {
    }

    public PlacementRuleSpecFluent(PlacementRuleSpec instance) {
        PlacementRuleSpec placementRuleSpec = instance = instance != null ? instance : new PlacementRuleSpec();
        if (instance != null) {
            this.withClusterConditions(instance.getClusterConditions());
            this.withClusterReplicas(instance.getClusterReplicas());
            this.withClusterSelector(instance.getClusterSelector());
            this.withClusters(instance.getClusters());
            this.withPolicies(instance.getPolicies());
            this.withResourceHint(instance.getResourceHint());
            this.withSchedulerName(instance.getSchedulerName());
            this.withClusterConditions(instance.getClusterConditions());
            this.withClusterReplicas(instance.getClusterReplicas());
            this.withClusterSelector(instance.getClusterSelector());
            this.withClusters(instance.getClusters());
            this.withPolicies(instance.getPolicies());
            this.withResourceHint(instance.getResourceHint());
            this.withSchedulerName(instance.getSchedulerName());
        }
    }

    public A addToClusterConditions(int index, ClusterConditionFilter item) {
        if (this.clusterConditions == null) {
            this.clusterConditions = new ArrayList();
        }
        ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);
        if (index < 0 || index >= this.clusterConditions.size()) {
            this._visitables.get((Object)"clusterConditions").add(builder);
            this.clusterConditions.add(builder);
        } else {
            this._visitables.get((Object)"clusterConditions").add(index, builder);
            this.clusterConditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClusterConditions(int index, ClusterConditionFilter item) {
        if (this.clusterConditions == null) {
            this.clusterConditions = new ArrayList();
        }
        ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);
        if (index < 0 || index >= this.clusterConditions.size()) {
            this._visitables.get((Object)"clusterConditions").add(builder);
            this.clusterConditions.add(builder);
        } else {
            this._visitables.get((Object)"clusterConditions").set(index, builder);
            this.clusterConditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClusterConditions(ClusterConditionFilter ... items) {
        if (this.clusterConditions == null) {
            this.clusterConditions = new ArrayList();
        }
        for (ClusterConditionFilter item : items) {
            ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);
            this._visitables.get((Object)"clusterConditions").add(builder);
            this.clusterConditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClusterConditions(Collection<ClusterConditionFilter> items) {
        if (this.clusterConditions == null) {
            this.clusterConditions = new ArrayList();
        }
        for (ClusterConditionFilter item : items) {
            ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);
            this._visitables.get((Object)"clusterConditions").add(builder);
            this.clusterConditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterConditions(ClusterConditionFilter ... items) {
        if (this.clusterConditions == null) {
            return (A)((Object)this);
        }
        for (ClusterConditionFilter item : items) {
            ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);
            this._visitables.get((Object)"clusterConditions").remove((Object)builder);
            this.clusterConditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusterConditions(Collection<ClusterConditionFilter> items) {
        if (this.clusterConditions == null) {
            return (A)((Object)this);
        }
        for (ClusterConditionFilter item : items) {
            ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);
            this._visitables.get((Object)"clusterConditions").remove((Object)builder);
            this.clusterConditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClusterConditions(Predicate<ClusterConditionFilterBuilder> predicate) {
        if (this.clusterConditions == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterConditionFilterBuilder> each = this.clusterConditions.iterator();
        List visitables = this._visitables.get((Object)"clusterConditions");
        while (each.hasNext()) {
            ClusterConditionFilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClusterConditionFilter> buildClusterConditions() {
        return this.clusterConditions != null ? PlacementRuleSpecFluent.build(this.clusterConditions) : null;
    }

    public ClusterConditionFilter buildClusterCondition(int index) {
        return this.clusterConditions.get(index).build();
    }

    public ClusterConditionFilter buildFirstClusterCondition() {
        return this.clusterConditions.get(0).build();
    }

    public ClusterConditionFilter buildLastClusterCondition() {
        return this.clusterConditions.get(this.clusterConditions.size() - 1).build();
    }

    public ClusterConditionFilter buildMatchingClusterCondition(Predicate<ClusterConditionFilterBuilder> predicate) {
        for (ClusterConditionFilterBuilder item : this.clusterConditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClusterCondition(Predicate<ClusterConditionFilterBuilder> predicate) {
        for (ClusterConditionFilterBuilder item : this.clusterConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterConditions(List<ClusterConditionFilter> clusterConditions) {
        if (this.clusterConditions != null) {
            this._visitables.get((Object)"clusterConditions").clear();
        }
        if (clusterConditions != null) {
            this.clusterConditions = new ArrayList();
            for (ClusterConditionFilter item : clusterConditions) {
                this.addToClusterConditions(item);
            }
        } else {
            this.clusterConditions = null;
        }
        return (A)((Object)this);
    }

    public A withClusterConditions(ClusterConditionFilter ... clusterConditions) {
        if (this.clusterConditions != null) {
            this.clusterConditions.clear();
            this._visitables.remove((Object)"clusterConditions");
        }
        if (clusterConditions != null) {
            for (ClusterConditionFilter item : clusterConditions) {
                this.addToClusterConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusterConditions() {
        return this.clusterConditions != null && !this.clusterConditions.isEmpty();
    }

    public A addNewClusterCondition(String status, String type) {
        return this.addToClusterConditions(new ClusterConditionFilter(status, type));
    }

    public ClusterConditionsNested<A> addNewClusterCondition() {
        return new ClusterConditionsNested(-1, null);
    }

    public ClusterConditionsNested<A> addNewClusterConditionLike(ClusterConditionFilter item) {
        return new ClusterConditionsNested(-1, item);
    }

    public ClusterConditionsNested<A> setNewClusterConditionLike(int index, ClusterConditionFilter item) {
        return new ClusterConditionsNested(index, item);
    }

    public ClusterConditionsNested<A> editClusterCondition(int index) {
        if (this.clusterConditions.size() <= index) {
            throw new RuntimeException("Can't edit clusterConditions. Index exceeds size.");
        }
        return this.setNewClusterConditionLike(index, this.buildClusterCondition(index));
    }

    public ClusterConditionsNested<A> editFirstClusterCondition() {
        if (this.clusterConditions.size() == 0) {
            throw new RuntimeException("Can't edit first clusterConditions. The list is empty.");
        }
        return this.setNewClusterConditionLike(0, this.buildClusterCondition(0));
    }

    public ClusterConditionsNested<A> editLastClusterCondition() {
        int index = this.clusterConditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterConditions. The list is empty.");
        }
        return this.setNewClusterConditionLike(index, this.buildClusterCondition(index));
    }

    public ClusterConditionsNested<A> editMatchingClusterCondition(Predicate<ClusterConditionFilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterConditions.size(); ++i) {
            if (!predicate.test(this.clusterConditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterConditions. No match found.");
        }
        return this.setNewClusterConditionLike(index, this.buildClusterCondition(index));
    }

    public Integer getClusterReplicas() {
        return this.clusterReplicas;
    }

    public A withClusterReplicas(Integer clusterReplicas) {
        this.clusterReplicas = clusterReplicas;
        return (A)((Object)this);
    }

    public boolean hasClusterReplicas() {
        return this.clusterReplicas != null;
    }

    public LabelSelector buildClusterSelector() {
        return this.clusterSelector != null ? this.clusterSelector.build() : null;
    }

    public A withClusterSelector(LabelSelector clusterSelector) {
        this._visitables.get((Object)"clusterSelector").remove(this.clusterSelector);
        if (clusterSelector != null) {
            this.clusterSelector = new LabelSelectorBuilder(clusterSelector);
            this._visitables.get((Object)"clusterSelector").add(this.clusterSelector);
        } else {
            this.clusterSelector = null;
            this._visitables.get((Object)"clusterSelector").remove(this.clusterSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasClusterSelector() {
        return this.clusterSelector != null;
    }

    public ClusterSelectorNested<A> withNewClusterSelector() {
        return new ClusterSelectorNested(null);
    }

    public ClusterSelectorNested<A> withNewClusterSelectorLike(LabelSelector item) {
        return new ClusterSelectorNested(item);
    }

    public ClusterSelectorNested<A> editClusterSelector() {
        return this.withNewClusterSelectorLike(Optional.ofNullable(this.buildClusterSelector()).orElse(null));
    }

    public ClusterSelectorNested<A> editOrNewClusterSelector() {
        return this.withNewClusterSelectorLike(Optional.ofNullable(this.buildClusterSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public ClusterSelectorNested<A> editOrNewClusterSelectorLike(LabelSelector item) {
        return this.withNewClusterSelectorLike(Optional.ofNullable(this.buildClusterSelector()).orElse(item));
    }

    public A addToClusters(int index, GenericClusterReference item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
        if (index < 0 || index >= this.clusters.size()) {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        } else {
            this._visitables.get((Object)"clusters").add(index, builder);
            this.clusters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClusters(int index, GenericClusterReference item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
        if (index < 0 || index >= this.clusters.size()) {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        } else {
            this._visitables.get((Object)"clusters").set(index, builder);
            this.clusters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClusters(GenericClusterReference ... items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClusters(Collection<GenericClusterReference> items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClusters(GenericClusterReference ... items) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").remove((Object)builder);
            this.clusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusters(Collection<GenericClusterReference> items) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").remove((Object)builder);
            this.clusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClusters(Predicate<GenericClusterReferenceBuilder> predicate) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        Iterator<GenericClusterReferenceBuilder> each = this.clusters.iterator();
        List visitables = this._visitables.get((Object)"clusters");
        while (each.hasNext()) {
            GenericClusterReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GenericClusterReference> buildClusters() {
        return this.clusters != null ? PlacementRuleSpecFluent.build(this.clusters) : null;
    }

    public GenericClusterReference buildCluster(int index) {
        return this.clusters.get(index).build();
    }

    public GenericClusterReference buildFirstCluster() {
        return this.clusters.get(0).build();
    }

    public GenericClusterReference buildLastCluster() {
        return this.clusters.get(this.clusters.size() - 1).build();
    }

    public GenericClusterReference buildMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
        for (GenericClusterReferenceBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
        for (GenericClusterReferenceBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusters(List<GenericClusterReference> clusters) {
        if (this.clusters != null) {
            this._visitables.get((Object)"clusters").clear();
        }
        if (clusters != null) {
            this.clusters = new ArrayList();
            for (GenericClusterReference item : clusters) {
                this.addToClusters(item);
            }
        } else {
            this.clusters = null;
        }
        return (A)((Object)this);
    }

    public A withClusters(GenericClusterReference ... clusters) {
        if (this.clusters != null) {
            this.clusters.clear();
            this._visitables.remove((Object)"clusters");
        }
        if (clusters != null) {
            for (GenericClusterReference item : clusters) {
                this.addToClusters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusters() {
        return this.clusters != null && !this.clusters.isEmpty();
    }

    public A addNewCluster(String name) {
        return this.addToClusters(new GenericClusterReference(name));
    }

    public ClustersNested<A> addNewCluster() {
        return new ClustersNested(-1, null);
    }

    public ClustersNested<A> addNewClusterLike(GenericClusterReference item) {
        return new ClustersNested(-1, item);
    }

    public ClustersNested<A> setNewClusterLike(int index, GenericClusterReference item) {
        return new ClustersNested(index, item);
    }

    public ClustersNested<A> editCluster(int index) {
        if (this.clusters.size() <= index) {
            throw new RuntimeException("Can't edit clusters. Index exceeds size.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public ClustersNested<A> editFirstCluster() {
        if (this.clusters.size() == 0) {
            throw new RuntimeException("Can't edit first clusters. The list is empty.");
        }
        return this.setNewClusterLike(0, this.buildCluster(0));
    }

    public ClustersNested<A> editLastCluster() {
        int index = this.clusters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusters. The list is empty.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public ClustersNested<A> editMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (!predicate.test(this.clusters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusters. No match found.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public A addToPolicies(int index, ObjectReference item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").add(index, builder);
            this.policies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPolicies(int index, ObjectReference item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").set(index, builder);
            this.policies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPolicies(ObjectReference ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPolicies(Collection<ObjectReference> items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPolicies(ObjectReference ... items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"policies").remove(builder);
            this.policies.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPolicies(Collection<ObjectReference> items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"policies").remove(builder);
            this.policies.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPolicies(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        Iterator<ObjectReferenceBuilder> each = this.policies.iterator();
        List visitables = this._visitables.get((Object)"policies");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ObjectReference> buildPolicies() {
        return this.policies != null ? PlacementRuleSpecFluent.build(this.policies) : null;
    }

    public ObjectReference buildPolicy(int index) {
        return this.policies.get(index).build();
    }

    public ObjectReference buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    public ObjectReference buildLastPolicy() {
        return this.policies.get(this.policies.size() - 1).build();
    }

    public ObjectReference buildMatchingPolicy(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPolicy(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPolicies(List<ObjectReference> policies) {
        if (this.policies != null) {
            this._visitables.get((Object)"policies").clear();
        }
        if (policies != null) {
            this.policies = new ArrayList();
            for (ObjectReference item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)((Object)this);
    }

    public A withPolicies(ObjectReference ... policies) {
        if (this.policies != null) {
            this.policies.clear();
            this._visitables.remove((Object)"policies");
        }
        if (policies != null) {
            for (ObjectReference item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    public PoliciesNested<A> addNewPolicy() {
        return new PoliciesNested(-1, null);
    }

    public PoliciesNested<A> addNewPolicyLike(ObjectReference item) {
        return new PoliciesNested(-1, item);
    }

    public PoliciesNested<A> setNewPolicyLike(int index, ObjectReference item) {
        return new PoliciesNested(index, item);
    }

    public PoliciesNested<A> editPolicy(int index) {
        if (this.policies.size() <= index) {
            throw new RuntimeException("Can't edit policies. Index exceeds size.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editFirstPolicy() {
        if (this.policies.size() == 0) {
            throw new RuntimeException("Can't edit first policies. The list is empty.");
        }
        return this.setNewPolicyLike(0, this.buildPolicy(0));
    }

    public PoliciesNested<A> editLastPolicy() {
        int index = this.policies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last policies. The list is empty.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editMatchingPolicy(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policies.size(); ++i) {
            if (!predicate.test(this.policies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching policies. No match found.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public ResourceHint buildResourceHint() {
        return this.resourceHint != null ? this.resourceHint.build() : null;
    }

    public A withResourceHint(ResourceHint resourceHint) {
        this._visitables.get((Object)"resourceHint").remove((Object)this.resourceHint);
        if (resourceHint != null) {
            this.resourceHint = new ResourceHintBuilder(resourceHint);
            this._visitables.get((Object)"resourceHint").add(this.resourceHint);
        } else {
            this.resourceHint = null;
            this._visitables.get((Object)"resourceHint").remove((Object)this.resourceHint);
        }
        return (A)((Object)this);
    }

    public boolean hasResourceHint() {
        return this.resourceHint != null;
    }

    public A withNewResourceHint(String order, String type) {
        return this.withResourceHint(new ResourceHint(order, type));
    }

    public ResourceHintNested<A> withNewResourceHint() {
        return new ResourceHintNested(null);
    }

    public ResourceHintNested<A> withNewResourceHintLike(ResourceHint item) {
        return new ResourceHintNested(item);
    }

    public ResourceHintNested<A> editResourceHint() {
        return this.withNewResourceHintLike(Optional.ofNullable(this.buildResourceHint()).orElse(null));
    }

    public ResourceHintNested<A> editOrNewResourceHint() {
        return this.withNewResourceHintLike(Optional.ofNullable(this.buildResourceHint()).orElse(new ResourceHintBuilder().build()));
    }

    public ResourceHintNested<A> editOrNewResourceHintLike(ResourceHint item) {
        return this.withNewResourceHintLike(Optional.ofNullable(this.buildResourceHint()).orElse(item));
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)((Object)this);
    }

    public boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlacementRuleSpecFluent that = (PlacementRuleSpecFluent)((Object)o);
        if (!Objects.equals(this.clusterConditions, that.clusterConditions)) {
            return false;
        }
        if (!Objects.equals(this.clusterReplicas, that.clusterReplicas)) {
            return false;
        }
        if (!Objects.equals(this.clusterSelector, that.clusterSelector)) {
            return false;
        }
        if (!Objects.equals(this.clusters, that.clusters)) {
            return false;
        }
        if (!Objects.equals(this.policies, that.policies)) {
            return false;
        }
        if (!Objects.equals((Object)this.resourceHint, (Object)that.resourceHint)) {
            return false;
        }
        return Objects.equals(this.schedulerName, that.schedulerName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clusterConditions, this.clusterReplicas, this.clusterSelector, this.clusters, this.policies, this.resourceHint, this.schedulerName, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterConditions != null && !this.clusterConditions.isEmpty()) {
            sb.append("clusterConditions:");
            sb.append(this.clusterConditions + ",");
        }
        if (this.clusterReplicas != null) {
            sb.append("clusterReplicas:");
            sb.append(this.clusterReplicas + ",");
        }
        if (this.clusterSelector != null) {
            sb.append("clusterSelector:");
            sb.append(this.clusterSelector + ",");
        }
        if (this.clusters != null && !this.clusters.isEmpty()) {
            sb.append("clusters:");
            sb.append(this.clusters + ",");
        }
        if (this.policies != null && !this.policies.isEmpty()) {
            sb.append("policies:");
            sb.append(this.policies + ",");
        }
        if (this.resourceHint != null) {
            sb.append("resourceHint:");
            sb.append((Object)((Object)this.resourceHint) + ",");
        }
        if (this.schedulerName != null) {
            sb.append("schedulerName:");
            sb.append(this.schedulerName);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourceHintNested<N>
    extends ResourceHintFluent<ResourceHintNested<N>>
    implements Nested<N> {
        ResourceHintBuilder builder;

        ResourceHintNested(ResourceHint item) {
            this.builder = new ResourceHintBuilder(this, item);
        }

        public N and() {
            return (N)PlacementRuleSpecFluent.this.withResourceHint(this.builder.build());
        }

        public N endResourceHint() {
            return this.and();
        }
    }

    public class PoliciesNested<N>
    extends ObjectReferenceFluent<PoliciesNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;
        int index;

        PoliciesNested(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)PlacementRuleSpecFluent.this.setToPolicies(this.index, this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }

    public class ClustersNested<N>
    extends GenericClusterReferenceFluent<ClustersNested<N>>
    implements Nested<N> {
        GenericClusterReferenceBuilder builder;
        int index;

        ClustersNested(int index, GenericClusterReference item) {
            this.index = index;
            this.builder = new GenericClusterReferenceBuilder(this, item);
        }

        public N and() {
            return (N)PlacementRuleSpecFluent.this.setToClusters(this.index, this.builder.build());
        }

        public N endCluster() {
            return this.and();
        }
    }

    public class ClusterSelectorNested<N>
    extends LabelSelectorFluent<ClusterSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        ClusterSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)PlacementRuleSpecFluent.this.withClusterSelector(this.builder.build());
        }

        public N endClusterSelector() {
            return this.and();
        }
    }

    public class ClusterConditionsNested<N>
    extends ClusterConditionFilterFluent<ClusterConditionsNested<N>>
    implements Nested<N> {
        ClusterConditionFilterBuilder builder;
        int index;

        ClusterConditionsNested(int index, ClusterConditionFilter item) {
            this.index = index;
            this.builder = new ClusterConditionFilterBuilder(this, item);
        }

        public N and() {
            return (N)PlacementRuleSpecFluent.this.setToClusterConditions(this.index, this.builder.build());
        }

        public N endClusterCondition() {
            return this.and();
        }
    }
}

