/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1.ArgoServerSpec;
import io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1.ArgoServerSpecBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1.ArgoServerSpecFluent;
import io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1.GitOpsClusterSpec;
import java.util.Objects;
import java.util.Optional;

public class GitOpsClusterSpecFluent<A extends GitOpsClusterSpecFluent<A>>
extends BaseFluent<A> {
    private ArgoServerSpecBuilder argoServer;
    private ObjectReferenceBuilder placementRef;

    public GitOpsClusterSpecFluent() {
    }

    public GitOpsClusterSpecFluent(GitOpsClusterSpec instance) {
        GitOpsClusterSpec gitOpsClusterSpec = instance = instance != null ? instance : new GitOpsClusterSpec();
        if (instance != null) {
            this.withArgoServer(instance.getArgoServer());
            this.withPlacementRef(instance.getPlacementRef());
            this.withArgoServer(instance.getArgoServer());
            this.withPlacementRef(instance.getPlacementRef());
        }
    }

    public ArgoServerSpec buildArgoServer() {
        return this.argoServer != null ? this.argoServer.build() : null;
    }

    public A withArgoServer(ArgoServerSpec argoServer) {
        this._visitables.get((Object)"argoServer").remove((Object)this.argoServer);
        if (argoServer != null) {
            this.argoServer = new ArgoServerSpecBuilder(argoServer);
            this._visitables.get((Object)"argoServer").add(this.argoServer);
        } else {
            this.argoServer = null;
            this._visitables.get((Object)"argoServer").remove((Object)this.argoServer);
        }
        return (A)((Object)this);
    }

    public boolean hasArgoServer() {
        return this.argoServer != null;
    }

    public A withNewArgoServer(String argoNamespace, String cluster) {
        return this.withArgoServer(new ArgoServerSpec(argoNamespace, cluster));
    }

    public ArgoServerNested<A> withNewArgoServer() {
        return new ArgoServerNested(null);
    }

    public ArgoServerNested<A> withNewArgoServerLike(ArgoServerSpec item) {
        return new ArgoServerNested(item);
    }

    public ArgoServerNested<A> editArgoServer() {
        return this.withNewArgoServerLike(Optional.ofNullable(this.buildArgoServer()).orElse(null));
    }

    public ArgoServerNested<A> editOrNewArgoServer() {
        return this.withNewArgoServerLike(Optional.ofNullable(this.buildArgoServer()).orElse(new ArgoServerSpecBuilder().build()));
    }

    public ArgoServerNested<A> editOrNewArgoServerLike(ArgoServerSpec item) {
        return this.withNewArgoServerLike(Optional.ofNullable(this.buildArgoServer()).orElse(item));
    }

    public ObjectReference buildPlacementRef() {
        return this.placementRef != null ? this.placementRef.build() : null;
    }

    public A withPlacementRef(ObjectReference placementRef) {
        this._visitables.get((Object)"placementRef").remove(this.placementRef);
        if (placementRef != null) {
            this.placementRef = new ObjectReferenceBuilder(placementRef);
            this._visitables.get((Object)"placementRef").add(this.placementRef);
        } else {
            this.placementRef = null;
            this._visitables.get((Object)"placementRef").remove(this.placementRef);
        }
        return (A)((Object)this);
    }

    public boolean hasPlacementRef() {
        return this.placementRef != null;
    }

    public PlacementRefNested<A> withNewPlacementRef() {
        return new PlacementRefNested(null);
    }

    public PlacementRefNested<A> withNewPlacementRefLike(ObjectReference item) {
        return new PlacementRefNested(item);
    }

    public PlacementRefNested<A> editPlacementRef() {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(null));
    }

    public PlacementRefNested<A> editOrNewPlacementRef() {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public PlacementRefNested<A> editOrNewPlacementRefLike(ObjectReference item) {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitOpsClusterSpecFluent that = (GitOpsClusterSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.argoServer, (Object)that.argoServer)) {
            return false;
        }
        return Objects.equals(this.placementRef, that.placementRef);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.argoServer, this.placementRef, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.argoServer != null) {
            sb.append("argoServer:");
            sb.append((Object)((Object)this.argoServer) + ",");
        }
        if (this.placementRef != null) {
            sb.append("placementRef:");
            sb.append(this.placementRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PlacementRefNested<N>
    extends ObjectReferenceFluent<PlacementRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        PlacementRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)GitOpsClusterSpecFluent.this.withPlacementRef(this.builder.build());
        }

        public N endPlacementRef() {
            return this.and();
        }
    }

    public class ArgoServerNested<N>
    extends ArgoServerSpecFluent<ArgoServerNested<N>>
    implements Nested<N> {
        ArgoServerSpecBuilder builder;

        ArgoServerNested(ArgoServerSpec item) {
            this.builder = new ArgoServerSpecBuilder(this, item);
        }

        public N and() {
            return (N)GitOpsClusterSpecFluent.this.withArgoServer(this.builder.build());
        }

        public N endArgoServer() {
            return this.and();
        }
    }
}

