package io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterConditionFilterBuilder extends ClusterConditionFilterFluent<ClusterConditionFilterBuilder> implements VisitableBuilder<ClusterConditionFilter,ClusterConditionFilterBuilder>{
  public ClusterConditionFilterBuilder() {
    this(false);
  }
  public ClusterConditionFilterBuilder(Boolean validationEnabled) {
    this(new ClusterConditionFilter(), validationEnabled);
  }
  public ClusterConditionFilterBuilder(ClusterConditionFilterFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterConditionFilterBuilder(ClusterConditionFilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterConditionFilter(), validationEnabled);
  }
  public ClusterConditionFilterBuilder(ClusterConditionFilterFluent<?> fluent,ClusterConditionFilter instance) {
    this(fluent, instance, false);
  }
  public ClusterConditionFilterBuilder(ClusterConditionFilterFluent<?> fluent,ClusterConditionFilter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterConditionFilter());

    if (instance != null) {
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterConditionFilterBuilder(ClusterConditionFilter instance) {
    this(instance,false);
  }
  public ClusterConditionFilterBuilder(ClusterConditionFilter instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterConditionFilter());

    if (instance != null) {
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterConditionFilterFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterConditionFilter build() {
    ClusterConditionFilter buildable = new ClusterConditionFilter(fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}