package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitOpsClusterStatusBuilder extends GitOpsClusterStatusFluent<GitOpsClusterStatusBuilder> implements VisitableBuilder<GitOpsClusterStatus,GitOpsClusterStatusBuilder>{
  public GitOpsClusterStatusBuilder() {
    this(false);
  }
  public GitOpsClusterStatusBuilder(Boolean validationEnabled) {
    this(new GitOpsClusterStatus(), validationEnabled);
  }
  public GitOpsClusterStatusBuilder(GitOpsClusterStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public GitOpsClusterStatusBuilder(GitOpsClusterStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitOpsClusterStatus(), validationEnabled);
  }
  public GitOpsClusterStatusBuilder(GitOpsClusterStatusFluent<?> fluent,GitOpsClusterStatus instance) {
    this(fluent, instance, false);
  }
  public GitOpsClusterStatusBuilder(GitOpsClusterStatusFluent<?> fluent,GitOpsClusterStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GitOpsClusterStatus());

    if (instance != null) {
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withPhase(instance.getPhase());
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withPhase(instance.getPhase());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitOpsClusterStatusBuilder(GitOpsClusterStatus instance) {
    this(instance,false);
  }
  public GitOpsClusterStatusBuilder(GitOpsClusterStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GitOpsClusterStatus());

    if (instance != null) {
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withPhase(instance.getPhase());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withPhase(instance.getPhase());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitOpsClusterStatusFluent<?> fluent;
  Boolean validationEnabled;
  public GitOpsClusterStatus build() {
    GitOpsClusterStatus buildable = new GitOpsClusterStatus(fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getPhase());
    return buildable;
  }
  
}