package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitOpsClusterSpecBuilder extends GitOpsClusterSpecFluent<GitOpsClusterSpecBuilder> implements VisitableBuilder<GitOpsClusterSpec,GitOpsClusterSpecBuilder>{
  public GitOpsClusterSpecBuilder() {
    this(false);
  }
  public GitOpsClusterSpecBuilder(Boolean validationEnabled) {
    this(new GitOpsClusterSpec(), validationEnabled);
  }
  public GitOpsClusterSpecBuilder(GitOpsClusterSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public GitOpsClusterSpecBuilder(GitOpsClusterSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitOpsClusterSpec(), validationEnabled);
  }
  public GitOpsClusterSpecBuilder(GitOpsClusterSpecFluent<?> fluent,GitOpsClusterSpec instance) {
    this(fluent, instance, false);
  }
  public GitOpsClusterSpecBuilder(GitOpsClusterSpecFluent<?> fluent,GitOpsClusterSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GitOpsClusterSpec());

    if (instance != null) {
      fluent.withArgoServer(instance.getArgoServer());
      fluent.withPlacementRef(instance.getPlacementRef());
      fluent.withArgoServer(instance.getArgoServer());
      fluent.withPlacementRef(instance.getPlacementRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitOpsClusterSpecBuilder(GitOpsClusterSpec instance) {
    this(instance,false);
  }
  public GitOpsClusterSpecBuilder(GitOpsClusterSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GitOpsClusterSpec());

    if (instance != null) {
      this.withArgoServer(instance.getArgoServer());
      this.withPlacementRef(instance.getPlacementRef());
      this.withArgoServer(instance.getArgoServer());
      this.withPlacementRef(instance.getPlacementRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitOpsClusterSpecFluent<?> fluent;
  Boolean validationEnabled;
  public GitOpsClusterSpec build() {
    GitOpsClusterSpec buildable = new GitOpsClusterSpec(fluent.buildArgoServer(),fluent.buildPlacementRef());
    return buildable;
  }
  
}